#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/jobutil/provisioningUtil.pl /main/2 2010/11/05 21:55:15 rummadi Exp $
#
# provisioningUtil.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      provisioningUtil.pl - Provisioning Util file
#
#    DESCRIPTION
#      This is a util file to get the secret properties.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    amathur     10/21/10 - fix trimming type
#    rakerosh    08/16/10 - Creation
# 
sub getOraSecretPropertyMap()
{ 
  my %hashmap; 
  $start = 0; 
  $done = 0; 
 
  while ( <STDIN> ) 
  { 
    $line = $_; 
    chop($line); 
 
    if ( $start == 0 ) 
    { 
      if ( $line =~ /EM_PROV_SECRET_BEGIN/ ) 
      { 
        $start = 1; 
      } 
    } 
    else 
    { 
      if ( $line =~ /EM_PROV_SECRET_END/ ) 
      { 
        last; 
      } 
      else 
      { 
        $line =~ s/^\s+//; #remove leading spaces 
        $line =~ s/\s+$//; #remove trailing spaces 
        $idx = index ($line, '='); 
        $key = substr ($line, 0, $idx); 
        $value = substr ($line, $idx+1); 
        $hashmap{$key} = $value; 
      } 
    } 
  } 
  return %hashmap; 
} 
1;
