
if ( !defined $ENV{'EMHA_SKIP_LOCAL_IMPORTS'} )
{
  require "emd_common.pl";
}

use IO::Socket;
use strict;
use File::Basename;
use File::Copy;
use Net::FTP;
use File::Temp qw/ tempfile tempdir /;
use vars qw($OS $NT $S $TEMP $CP $MV $PS $DF $DELIMITER $Registry);

# Check if a specified directory exists
# # Return OK if the directory exists, otherwise, return NOK.
# # dirExists(dirName)
sub dirExists
{
  my ($dirName) = @_;
  if(! -e "$dirName")
  {
    EMD_PERL_DEBUG("multioms_common.dirExists(): Directory $dirName does not exist");
    return "NOK";
  }
  elsif(! -d "$dirName")
  {
    EMD_PERL_DEBUG("multioms_common.dirExists(): $dirName is not a directory");
    return "NOK";
  }
  EMD_PERL_DEBUG("multioms_common.dirExists(): Directory $dirName exists");
  return "OK";
}

# Check if multiple directoris exist for given dir names
# # Return an array containing OK and NOK.
# # Flag OK is returned if the dir exists, otherwise, NOK is returned.
# # dirsExist(dirNameArray)
sub dirsExist
{
  my ($dirNameArray) = @_;
  my @dirNames = split /$DELIMITER/, $dirNameArray;
  my $existStatus = "";
  my $dirNames;
  
  foreach $dirNames (@dirNames)
  {
    if(! -e "$dirNames")
    {
      EMD_PERL_DEBUG("multioms_common.dirsExist(): Directory $dirNames does not exist");
      $existStatus .= "NOK:";
    }
    else
    {
      EMD_PERL_DEBUG("multioms_common.dirsExist(): Directory $dirNames exists");
      $existStatus .= "OK:";
    }
  }
  return
  $existStatus;
}

#my $p ="msHTTPSPort=17035;nmPort=17034;msUploadPort=17668;msUploadHTTPSPort=14487;msConsolePort=17816;msConsoleHTTPSPort=15430;";
#"msHTTPSPort=17035;nmPort=17034;msUploadPort=17668;msUploadHTTPSPort=14487;msConsolePort=17816;msConsoleHTTPSPort=15430";
#portCheck($p);
# Check if port specified is free on machine. 
# return an array of port : true / false
# if port is true, then it is free. If false then it is used by some other process
sub portCheck 
{
  my ($str) = @_;
  my $str = shift;
  my $returnStr = "";
  my %portpairs  = ($str =~m/([^=]*)=([^;]*);/g);
  while (my ($key, $value) = each %portpairs) 
  {
    if(!isPortFree($value))
    {
      EMD_PERL_DEBUG("multioms_common.portCheck(): $key port- $value provided is not free \n");
      $returnStr = $returnStr.$key."="."false".";";
    }else 
    {
      EMD_PERL_DEBUG("multioms_common.portCheck():$key port- $value is free \n");
      $returnStr = $returnStr.$key."="."true".";";
    }
    EMD_PERL_DEBUG("multioms_common.portCheck():$key _ $value,\n");
  }
  return $returnStr;
}

sub isPortFree
{
  my $port = $_[0];
  my $sock = new IO::Socket::INET (LocalHost => 'localhost',
    LocalPort => $port,
    Proto     => 'tcp',
    Listen    => 5);
  if($sock)
  {
    close($sock);
    return
    1;
  }
  return
  0;
}

#Check destination staging location
sub dirPermissionCheck 
{
  my ($dirName) = @_;
  if(! -r "$dirName")
  {
    EMD_PERL_DEBUG("multioms_common.dirPermission(): UID $> does not have read permission for $dirName");
    return "NOK";
  }
  if(! -w _)
  {
    EMD_PERL_DEBUG("multioms_common.dirPermission(): UID $> does not have write permission for $dirName");
    return "NOK";
  }
  EMD_PERL_DEBUG("multioms_common.dirPermission(): UID $> has read/write permission for $dirName");
  return "OK";
}

my $ftp;
my $newerr;
my $str="Testing FTP";
#checkFTP("/scratch/akandasa","/scratch/akandasa","stajv13.us.oracle.com","akandasa","Madurai92");
#Check FTP is enabled and transfer temp file.
#localDirName,remoteDirName,Destination,username,Password
sub checkFTP
{
my $localFile ="multioms.txt";
my $remoteFile ="multioms.txt";

my ($localDirName, $remoteDirName,$destination,$username,$password)=@_;
EMD_PERL_DEBUG("localDirName....$localDirName");
EMD_PERL_DEBUG("remoteDirName...$remoteDirName");
EMD_PERL_DEBUG("destination....$destination");

chdir($localDirName) or die("$! Can't cd to $localDirName");
open FILE, ">>$localDirName/multioms.txt" or die "Couldn't create temp file.";
print FILE $str;
close FILE;

$newerr=0;
   #Check ftp is enabled
   $ftp=Net::FTP->new($destination,Timeout=>240) or $newerr=1;
        if ($newerr) {
           EMD_PERL_DEBUG("Can't connect to $destination \n");
      return "NOK";
        }else{
      EMD_PERL_DEBUG("Connected \n");
        }
   #Connect ftp using username/password
   $ftp->login("$username","$password") or $newerr=1;
        if ($newerr) {
          EMD_PERL_DEBUG("Can't username  $destination with $username \n");
         $ftp->quit;
     return "NOK";
        }else{
     EMD_PERL_DEBUG("Connected to $destination with $username \n");
   }
   $ftp->binary(); # set binary mode
   #change directory , put file and then delete it
   $ftp->cwd($remoteDirName) or $newerr=1;
        if ($newerr) {
          EMD_PERL_DEBUG("Can't cd to $remoteDirName on  $destination \n");
          $ftp->quit;
     return "NOK";
        }else{
     EMD_PERL_DEBUG("changed directory to $remoteDirName on $destination \n");
   }
      $newerr=0;
      $ftp->put($localFile ,$remoteFile ) or $newerr=1;
     if ($newerr) {
        EMD_PERL_DEBUG("Error transferring $remoteFile \n");
        return "NOK";
     }
     $ftp->delete($remoteFile) or $newerr=1; #if not able to delete, right now don't return NOK

 #delete local tmp file
 chdir $localDirName;
 removeFile($localFile);
 return "OK";
}

sub removeFile
{
  my ($fileName) = @_;

  EMD_PERL_DEBUG("Delete temp file from source host $fileName\n");
  #unlink $fileName or warn "Could not delete '$fileName': $!";
   unlink $fileName;
}

                                                                          

                                      
