# 
# $Header: emagent/sysman/admin/scripts/nshPreFileSaveChk.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:52 pnayak Exp $
#
# nshPreFileSaveChk.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      nshPreFileSaveChk.pl - Script to check file attributes prior to saving
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ajere       02/03/05 - Windows: Fix get parent directory
#    ajere       08/30/04 - Creation
# 

require "emd_common.pl";

#############################################
# performPreFileSaveChk()
# Perform pre-save file checks
#############################################
sub performPreFileSaveChk() {
  #Input params
  my $osCmd    = $ARGV[0];
  my $fileName = $ARGV[1];

  my $directory = $fileName;
  my $preFileSaveChkOut = '';
  my $windowsOsCmd      = "cmd";
  my $unixOsCmd         = "/bin/sh";

  #Return flags
  my $isFileDirectory = 'false';
  my $fileExists = 'false';
  my $fileWrite = 'false';
  my $dirWrite = 'false';

  #Check if file is a directory file
  if(-d $fileName) {
  	#print ("$fileName is a directory!\n") ;
  	$isFileDirectory = 'true';
  }

  #Check if the file exists and has write permissions
  if (-e $fileName) {
  	#print "\n$fileName exists!\n";
  	$fileExists = 'true';

    if(-w $fileName) {
	  	#print "\n$fileName exists and has write permissions!\n";
	    $fileWrite = 'true';
    }
  }

  #Get the parent directory
  if ($osCmd eq $windowsOsCmd) {
    #Windows
    if($fileName =~ /(.*\\)/) {
      $directory = $1;
    }
  } elsif ($osCmd eq $unixOsCmd) {
    #UNIX
    if ($fileName =~ m!(.*\/)!) {
    	$directory = $1;
    }
  }
  #print ("directory = $directory\n");	

  #Check if the parent directory has write permission
	if ((-d $directory)&&(-w $directory)) {
 	  #print ("$directory has write access.\n");	
 	  $dirWrite = 'true';
  }

 $preFileSaveChkOut =  $isFileDirectory.'|'.$fileExists.'|'.$fileWrite.'|'.$dirWrite."\n";
 return $preFileSaveChkOut;
}

#For testing only
#my $preFileSaveChkOut = performPreFileSaveChk();
#print "$preFileSaveChkOut";
