#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/ocmdiscovery.pl /main/1 2012/03/23 04:12:09 ckalivar Exp $
#
# ocmdiscovery.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      ocmdiscovery.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ckalivar    02/16/12 - discovery metric script for OCM
#    ckalivar    02/15/12 - Creation
#
use File::Spec;
use emdcommon;

# targets.desc file path ccr_config_home/config/default/targets.desc
my $fileName = File::Spec->catfile( $ENV{'CCR_CONFIG_HOME'}, "config", "default", "targets.desc" );
my $var;

#only if the file exists
if ( ($fileName ne NIL) && (-e $fileName) )
{
  open (FILE,  $fileName);
  # open the file and add everything into single string
  while (<FILE>) {
    $var = $var.$_;
    chomp($var);
    $var =~ s/^\s+//;
    $var =~ s/\s+$//;
  }
  # replace the delimiter | with space , it might screw up the positions
  $var  =~ s/\|/ /g;
  print "em_result=ocm_plugin|ocm_module|$var|\n";
  close (FILE);
}
else
{
  emdcommon::EMD_PERL_ERROR("Unable to open  file $fileName\n");
  exit 1;
}
 
