# $Header: emagent/sysman/admin/scripts/oidPID.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:52 pnayak Exp $
#
# oidPID.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oidPID.pl - get all the process for ldap
#
#    DESCRIPTION
#      This script computes for Oracle Internet Directory Server 
#      the process size in VM, % physical memory and %CPU consumption
#
#    NOTES
#      USAGE oidPID.pl
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    10/21/02 - Added ENV for PATH
#    vsekuboy    10/18/02 - Changes for HP, Linux, AIX and Tru64
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    achoudha    12/12/01 -
#    achoudha    12/12/01 - Creation
# 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

chomp ($os = `uname -s`);
if ($os eq "SunOS" || $os eq "Linux") {
   @PSINFO = `ps -e -o fname,ppid,pid|grep oidldapd`;
}
elsif ($os eq "OSF1" || $os eq "AIX") {
   @PSINFO = `ps -e -o comm,ppid,pid|grep oidldapd`;
}
elsif ($os eq "HP-UX") {
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,ppid,pid|grep oidldapd`;
}
else {
   print "Platform - $os not supported\n";
}

$procID = 0;


$PID    = 0;

foreach $oidProcessInfo (@PSINFO)
{
    @data = split(/\s+/, $oidProcessInfo);
    if(1 == $data[1]) {
       $PID = $data[2];
       print "em_result=$PID\n";
    }
}
