#  $Header: emagent/sysman/admin/scripts/oidServLoad.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:52 pnayak Exp $
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oidServLoad.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script computes for Oracle Internet Directory Server 
#      the process size in VM, % physical memory and %CPU consumption
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vsekuboy    10/21/02 - Added ENV for PATH
#    vsekuboy    10/21/02 - Changes for HP, Linux, AIX and Tru64
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    ggilchri    08/10/01 - Creation
#

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

chomp ($os = `uname -s`);
if ($os eq "SunOS" || $os eq "Linux") {
   @PSINFO = `ps -e -o fname,pcpu|grep oidldapd`;
}
elsif ($os eq "OSF1" || $os eq "AIX") {
   @PSINFO = `ps -e -o comm,pcpu|grep oidldapd`;
}
elsif ($os eq "HP-UX") {
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,pcpu|grep oidldapd`;
}
else {
   print "Platform - $os not supported\n";
}

$CPU    = 0;

foreach $oidProcessInfo (@PSINFO)
{
  @data = split(/\s+/, $oidProcessInfo);
  $CPU    += $data[1];
}

print "$CPU\n";


