#  $Header: emagent/sysman/admin/scripts/oidServerUserSessions.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:31:52 pnayak Exp $
# 
# Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      oidServerUserSessions.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script computes the total number of user sessions established
#      with Oracle Internet Directory Server.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xshi        05/01/03 - fix for metric collect
#    vsekuboy    10/21/02 - Added ENV for PATH
#    vsekuboy    10/17/02 - Changes for HP and Linux during GIT5
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    xshi        09/13/01 - Creation
#

$portIndex = -1;
$numUserSessions = 0;
$oldPATH = $ENV{"PATH"};
$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin:/usr/ucb";
chomp ($os = `uname -s`);

@PSINFO = `ps -ef|grep oidldapd`;

# Get all the port numbers of OID servers
foreach $oidProcessInfo (@PSINFO)
{
  @data = split(/\s+/, $oidProcessInfo);
  $i = 0;
  foreach $token (@data)
  {
    if ("-p" eq $token)
    {
      $ports[++$portIndex] = $data[$i + 1];
      break;
    }
    $i++;
  }
}

foreach $portNo (@ports)
{
  if ($os eq "Linux") {
  $numUserSessions += `netstat -t tcp|grep ESTABLISHED|awk '{print \$4}'|grep "\:$portNo\"|wc -l`;
  }
  elsif ($os eq "HP-UX" || $os eq "OSF1" || $os eq "AIX") {  
  $numUserSessions += `netstat -a | grep "^tcp" | grep ESTABLISHED | awk '{print \$4}'|grep "\.$portNo\"|wc -l`;
  }
  elsif ($os eq "SunOS") {
  $numUserSessions += `netstat -P tcp|grep ESTABLISHED|awk '{print \$1}'|grep "\.$portNo\"|wc -l`;
  }
}

print ("em_result=$numUserSessions\n");

$ENV{PATH} = $oldPATH;


