#  $Header: emagent/sysman/admin/scripts/osLoad.pl /main/24 2010/12/31 03:47:11 cgnanasa Exp $
# 
# Copyright (c) 2001, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osLoad.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script is used in EMD to collect OS related statistics.  
#      Only Linux is supported.
#
#      The output of this script is :
#
#          em_result=$cpuAvg5Min|$numActivePgs|$noOfProcesses|$noOfUsers|$tps|
#                    0|$cpuIdleRaw|$cpuUserRaw|$cpuSysRaw|$cpuNiceRaw|$page_size|
#                    $realMemInKb|$freeMemInRaw|$usedSwapInRaw|$usedSwapInRaw|$freeSwapInRaw|$tps
#
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    cgnanasa    12/21/10 - Bug:10142366, cpu util fix
#    cgnanasa    07/23/10 - Normalizing run queue (ER:9646875)
#    cgnanasa    09/02/09 - Removing scan rate related metrics from the script
#    mjnoel      06/02/09 - Migrate the decvms changes forward to 10.3 label as
#                           per bug 8455777
#    jreguera    04/07/08 - added VMS implementation
#    mkiran      12/05/08 - 7492444: Skip partitions in totIO calc (2.4, 2.6)
#    mkiran      10/14/08 - 7423094: Ignore disk partitions 
#    ssalunke    07/16/08 - Change in MUI computation
#    shnavane    12/11/06 - Fix bug #5701916
#       shnavane 04/03/07 - Backport shnavane_bug-5701916 from main
#    rtakeish    02/07/-7 - Getting activeMem for bug5336607
#                         - Changing to get freeMem as KBytes
#    aptrived    07/11/06 - Backport aptrived_bug-4878743 from main 
#    sacgoyal    01/13/05 - bug#3845346 make script to linux relevent only 
#    sreddy      10/18/04 - latest code (bug#3838481), bug#3845346 included
#    rlal        08/20/04 - Define all vars for strict 
#    njagathe    07/12/04 - Merge PE Changes 
#    rlal        03/25/04 - Fix for bug 3533989
#    skumar      01/29/04 - fix for 1 user 
#    skumar      01/19/04 - paging changes 
#    skumar      01/07/04 - Creation
#    vsekuboy    10/25/02 - Added Tru64
#    vsekuboy    10/09/02 - Changes for Linux
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    lnhan       08/05/01 - Add number of processes on HP-UX
#    lnhan       04/04/01 - To handle different outputs returned by different versions of top
#    lnhan       03/12/01 - Some scripts by Ash Arnold are combined and modified
#                           to form the codes related HP. 
#                           On HP, if swapinfo fails to run swap value is set to 0.
#                           By default only root can run swapinfo on HP
#    lnhan       03/12/01 - Creation
#
if ($^O eq "VMS")
{
   system ("mcr agent_home:[bin]vms_stats.exe osload");
   exit (0);
}

exit 1 if ($^O ne "linux");

use strict;

use hostGenFunctions;

use constant NIL => '';


my $loadavg      = NIL;
my $loadavg1min  = NIL;
my $loadavg5min  = NIL;
my $loadavg15min = NIL;

my $nprocs    = NIL;
my $nusers    = NIL;

my $cpuidle = NIL;
my $cpuuser = NIL;
my $cpusys  = NIL;
my $cpuwait = 0;
my $cpuhi = 0;
my $cpusi = 0;

my $pagesize  = NIL;
my $realmemKB = NIL;
my $freemem   = NIL;
my $buffers = NIL;
my $cached = NIL;

my $usedswap = NIL;
my $freeswap = NIL;
my $totalswap = NIL;

my @data = ();
my $size = 0;
my @tokens = ();
my $page = '';
my $activeMem = NIL;

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/local/bin";

# Load averages and Number of Users Logged in
my $lc_all_original = $ENV{LC_ALL};  #Save the original LC_ALL
$ENV{LC_ALL} = "C";
$_ = `uptime` or die "Failed to run command uptime\n";
$ENV{LC_ALL} = $lc_all_original;     #Restore original LC_ALL

if (/.*,(\s+\d+ user).* load average:(.*)/)
{
  $nusers = trim($1);
  $loadavg = trim($2);
  $nusers =~ s/ user//;
}

die "Failed to get Number of users\n" if ($nusers eq NIL || $loadavg eq NIL);

($loadavg1min, $loadavg5min, $loadavg15min) = split(", ", $loadavg);

$nprocs = `ps -e | wc -l` or die "Failed to run ps";
chomp($nprocs);
$nprocs = trim($nprocs);
$pagesize = `getconf PAGE_SIZE`;
chomp($pagesize);


# CPU stats
$_ = `grep -F 'cpu ' /proc/stat` or die "Failed to run grep";
if (/cpu\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/)
{
  $cpuuser = $1;
  $cpuuser += $2;
  $cpusys  = $3;
  $cpuidle = $4;
  $cpuwait = $5;
  $cpuhi = $6;
  $cpusi = $7;
}
elsif (/cpu\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/)
{
  $cpuuser = $1;
  $cpuuser += $2;
  $cpusys  = $3;
  $cpuidle = $4;
}

# Memory and Swap Info
open FH, "/proc/meminfo" or die "Could not open /proc/meminfo\n";

while (<FH>)
{
  if (/MemTotal:\s+(\d+)/)
  {
    $realmemKB = $1;
  }
  if (/MemFree:\s+(\d+)/)
  {
    $freemem   = $1;
  }
  if (/Active:\s+(\d+)/)
  {
    $activeMem = $1;
  }
  if (/SwapTotal:\s+(\d+)/)
  {
    $totalswap = $1*1024;
  }
  if (/Buffers:\s+(\d+)/)
  {
    $buffers = $1;
  }
  if (/^Cached:\s+(\d+)/)
  {
    $cached = $1;
  }
  if (/SwapFree:\s+(\d+)/)
  {
    $freeswap = $1*1024;
    $usedswap = $totalswap - $freeswap;
    last;
  }
}

close FH;

# normalizing the system load (run queue length)
my $num_cpus = `grep cpu /proc/stat | tail -n +2 | wc -l`  or die "Failed to run grep on /proc/stat to find number of cpus";
chomp($num_cpus);
# error handling block
if($num_cpus == 0) 
{
  $num_cpus =1;
  print "em_warning=Unable to detect the number of cpus.Load average metric could be incorrect\n";
}

$loadavg1min = $loadavg1min/$num_cpus;
$loadavg5min = $loadavg5min/$num_cpus;
$loadavg15min= $loadavg15min/$num_cpus;

print "em_result=$loadavg1min|$loadavg5min|$loadavg15min|$nprocs|$nusers|$cpuidle|$cpuuser|$cpusys|$cpuwait|$cpuhi|$cpusi|$pagesize|$realmemKB|$freemem|$usedswap|$freeswap|$activeMem|$buffers|$cached\n";

exit 0;
