#  $Header: emagent/sysman/admin/scripts/osconfig.pl /main/28 2012/05/17 23:33:45 cgnanasa Exp $
# 
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osconfig.pl
#
#    Description:
#      This script is used in the EMD to ccollect OS configuration info.
#      The expected o/p if the script executes successfully is
#  
#  em_result=<OS>|<OSReleaseLevel>|<PatchLevel>|<Platform>|<Uptime>|<IP Addr>|<Target Version>|<Distribution>
#
#    MODIFIED  (MM/DD/YY)
#    cgnanasa 05/10/12 - PATH variable overridden (14015215)
#    nasounda 04/07/12 - TargetVersion fix for OEL6
#    nasounda 11/21/11 - check for /etc/oracle-release
#    nasounda 11/14/11 - Adding distribution on other ports
#    nasounda 05/16/11 - Adding targetversion for other ports
#    nasounda 03/23/11 - Fix for OEL machine OSName
#    nasounda 01/25/11 - Bug:10136591 - Adding target version , distribution
#    ssalunke 11/15/10 - adding windows dynamic properties computation code to
#                        osconfig.pl since host.xml is no longer port specific
#    cgnanasa 10/11/10 - Dynamic properties should not exceed 64 chars
#    rramaiah 11/25/09 - BUG 9054236 - NLS: THE VALUE OF LAST BOOTED ALWAYS
#                        SHOWS 2009-00-00 00:00:00
#    ssalunke 12/18/08 - who -b does not work on SLES
#    aptrived 01/31/08 - Backport aptrived_bug-6758581 from main
#    aptrived   01/28/08 - Bug#6758581, Doing fix for Bug#5076516 for all UNIX flavor
#    aptrived 03/03/06 - Bug#5076516, Collecting uptime in date-time format 
#                        for Linux 
#    aptrive  02/20/07 - Backport aptrived_bug-5076516 from main
#    ajayshar   09/28/06 -Bug#5448472 For AIX, os_release_level calculated using oslevel 
#    ajayshar 09/29/06 - Backport ajayshar_bug-5448472 from main
#    sacgoyal 03/06/05 - fix bug#4215387 
#    mbhoopat 03/10/04 - linux port 
#    nsharma  01/28/04 - Fix for united linux 
#    rzkrishn 07/28/03 - using nmupm for system boot time
#    vsekuboy 10/28/02 - Updated comments to reflect correct output
#    vsekuboy 10/24/02 - Changes for AIX and Tru64
#    vsekuboy 10/09/02 - Changes for HP and Linux
#    xxu      06/25/02 - remove /usr/local/bin/perl
#    njagathe 01/17/02 - Adding back more columns
#    njagathe 01/17/02 - Updating to only return 3 columns
#    vnukal   12/24/01 - fixing ip parsing glitch in 2.8
#    vnukal   10/22/01 - adding patch level and ip info to Config metric
#    vnukal   10/03/01 - reducing delay for top execution
#    vnukal   09/04/01 - Initial revision

require "emd_common.pl";
use hostGenFunctions;
#setting the max length to 63 to accomodate any new lines on the way to repos
my $MAX_PROP_LEN=63;
my $os_release_level;
my $isWindows = 0;
my $pathSep="";

if (($^O =~ "MSWin32") || ($^O =~ "Windows")) 
{
  $isWindows = 1;
  $pathSep=";";
  $ENV{PATH} = "$ENV{PATH}"."$pathSep"."$ENV{EMDROOT}/bin";
}
else
{
  $pathSep=":";
  #Non windows platforms will remain as it is.
  $ENV{PATH} = $ENV{PATH}.$pathSep. "/bin". $pathSep."/usr/bin". $pathSep."/usr/sbin". $pathSep."/usr/local/bin".$pathSep. "/sbin".$pathSep."$ENV{EMDROOT}/bin";
}
# accpts month in MON/MONTH format and returns in MM
# month index starts with 1
# if correct month is not found, return 0, meaning error
sub getMMFromMonth
{
    if     ((lc($_[0]) eq "jan") || (lc($_[0]) eq "january"))   {
	return 1;
    } elsif((lc($_[0]) eq "feb") || (lc($_[0]) eq "february"))  {
	return 2;
    } elsif((lc($_[0]) eq "mar") || (lc($_[0]) eq "march"))     {
	return 3;
    } elsif((lc($_[0]) eq "apr") || (lc($_[0]) eq "april"))     {
	return 4;
    } elsif((lc($_[0]) eq "may") || (lc($_[0]) eq "may"))       {
	return 5;
    } elsif((lc($_[0]) eq "jun") || (lc($_[0]) eq "june"))      {
	return 6;
    } elsif((lc($_[0]) eq "jul") || (lc($_[0]) eq "july"))      {
	return 7;
    } elsif((lc($_[0]) eq "aug") || (lc($_[0]) eq "august"))    {
	return 8;
    } elsif((lc($_[0]) eq "sep") || (lc($_[0]) eq "september")) {
	return 9;
    } elsif((lc($_[0]) eq "oct") || (lc($_[0]) eq "october"))   {
	return 10;
    } elsif((lc($_[0]) eq "nov") || (lc($_[0]) eq "november"))  {
	return 11;
    } elsif((lc($_[0]) eq "dec") || (lc($_[0]) eq "december"))  {
	return 12;
    }
    # could not find correct mon/month, return 0
    return 0;
}

sub getUptimeFormat1
{
    my $upsince_1 = shift;
    $upsince_1 =~ /system boot\s+([a-zA-Z0-9 :]+)/i ;
    $upsince_1 = $1;
    $upsince_1 =~ s/[\s]+/ /g;
    my @tmpstr_1 = split(/ /, $upsince_1);
    my @timeData_1 = localtime(time);
    chomp($uptime_1 = `uptime`);
    $uptime_1 =~ s/[\s]+/ /g;
    #Different kind of uptime possible as below
    #5:31am up 16 min(s), 1 user, load average: 0.20, 2.50, 2.36
    #7:26am up 2:12, 1 user, load average: 0.71, 0.30, 0.29
    #02:30:46 up 297 days, 13:28, 13 users, load average: 0.08, 0.21, 0.17
    #Below parsing should work for all
    $upsinceDay_1 = (split(/ /, $uptime_1))[3]; #This could be min also, but that's fine
    $upsinceYr_1 = ($timeData_1[5]+1900) - int($upsinceDay_1/365);
    if($upsinceDay_1 > $timeData_1[7])
    {
	$upsinceYr_1 -= 1;
    }
    my $uptime_1 = sprintf("%04d-%02d-%02d %02d:%02d:00", $upsinceYr_1, getMMFromMonth($tmpstr_1[0]), $tmpstr_1[1], (split(/:/,$tmpstr_1[2]))[0], (split(/:/,$tmpstr_1[2]))[1]);
    return $uptime_1;
}

sub getUptimeFormat2
{
    my $upsince_2 = shift;
    $upsince_2 =~ /system boot[\s]+(\d{1,4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2})$/i;
    $upsince_2 = $1;
    $uptime_2 = sprintf("$upsince_2:00");
    return $uptime_2;
}


$ENV{LC_ALL} = "C";

#if (($^O =~ "MSWin32") || ($^O =~ "Windows")) {
if ($isWindows == 1) 
{
    my $nmupm = $ENV{ORACLE_HOME}.'\\bin\\nmupm.exe';
    if ( -f $nmupm ) {
        my $res_win = `$nmupm config`;
        chomp($res_win);
        if ($res_win =~ m/em_result=([\s\S]*)/)
        {
            $res_win = $1;
            ($os,$os_release_level,$patchlevel,$platform,$uptime,$ip) = split(/\|/,$res_win);
        }
        else
        {
           EMD_PERL_ERROR("Error in nmupm output : $res_win");
print "failed";
           exit 1;
        }
    }
    else {
        EMD_PERL_ERROR("$nmupm does not exist");
        exit 1;
    }
}
if ($isWindows == 0) {
    chomp ($os = `uname -s`);
    if ( $os eq "SunOS" || $os eq "AIX" || $os eq "OSF1" ) {
	chomp ($os_release_level = `uname -r`);
	chomp ($patchlevel = `uname -v`);
	
	chomp($hostname = `hostname`);
	
	if ( $os eq "AIX" ) {
	    chomp ($os_release_level = `oslevel`);
            #Bug:10136591 - Changing the platform value to make it consistent like other ports.
	    chomp ($platform = `uname -p`);
	    chomp($pingop = `ping $hostname 1 1 | head -1`); 
	}
	elsif ( $os eq "OSF1" ) {
	    chomp ($platform = `uname -m`);
	    chomp($pingop = `ping -c 1 $hostname | head -1`);
	}
	else {
	    chomp ($platform = `uname -p`);
	    chomp($pingop = `ping -s $hostname 1 1`);
	}
	
	#get the first stuff between parenthesis.
	($ip) = $pingop =~ m/\((\S+)\)/o; 
	#ip address retrieval in v4 failed.Try retrieving using the host command
	if($ip eq "" || $ip eq "127.0.0.1")
	{
	    my $lc_all_original = $ENV{LC_ALL};  #Save the original LC_ALL
	    $ENV{LC_ALL} = "C";
	    if($os eq "AIX" )
	    {
		@hostOutput = `hostnew -a $hostname`;
		foreach $line (@hostOutput)
		{
		    chomp($line);
		    if($line =~ m/^$hostname/)
		    {
			my @tokens = split (/\s+/ ,$line);
			$ip = $tokens[$#tokens];
		    }
		}
	    }
	    else
	    {
		@hostOutput = `host -a $hostname`;
		$ip = getIPAddressFromHostOutput(\@hostOutput,\$hostname);
	    }
	    $ENV{LC_ALL} = $lc_all_original;     #Restore original LC_ALL
	}
	#ping6 format not known and leaving it for now.
    }
    elsif ( $os eq "HP-UX") {
	
	chomp ($os_release_level = `uname -r`);
	chomp ($model = `uname -mi`);
	
	if ( $model == "ia64" ) {
	    $platform="IA64";
	}
	else {
	    $platform="PA-RISC";
	}
	
	chomp ($patchlevel = `uname -v`);
	
	chomp($hostname = `hostname`);
	chomp($pingop = `/etc/ping $hostname -n 1`);
	
	#get the IP address
	$pingop =~ /bytes from (.*?):/;
	($ip) = $1;
	#ip address retrieval in v4 failed.Try retrieving using the host command
	if($ip eq "" || $ip eq "127.0.0.1")
	{
	    my $lc_all_original = $ENV{LC_ALL};  #Save the original LC_ALL
	    $ENV{LC_ALL} = "C";
	    @hostOutput = `host -a $hostname`;
	    $ENV{LC_ALL} = $lc_all_original;     #Restore original LC_ALL
	    
	    $ip = getIPAddressFromHostOutput(\@hostOutput,\$hostname);
	}
	#ping6 format not known and leaving it for now.
    }
    elsif ($os eq "Linux") {
	chomp ($platform = `uname -m`);
	chomp ($patchlevel = `uname -r`);
	
	if ( -r "/etc/SuSE-release" ) {
	    $os_release_level=`cat /etc/SuSE-release | tr '\n' ' ' `;
	}
        elsif ( -r "/etc/oracle-release" ) {
            $os_release_level=`cat /etc/oracle-release | tr '\n' ' ' `;
        }
        elsif ( -r "/etc/enterprise-release" ) {
            $os_release_level = `cat /etc/enterprise-release | tr '\n' ' ' `;
            $os_release_level =~ s/Enterprise Linux Enterprise Linux/Enterprise Linux/;
        }
	elsif ( -r "/etc/redhat-release") {
	    $os_release_level=`cat /etc/redhat-release | tr '\n' ' ' `;
	}
	elsif ( -r "/etc/UnitedLinux-release") {
	    $os_release_level=`cat /etc/UnitedLinux-release | tr '\n' ' ' `;
	}
	$host = `hostname`;
	# check ip address in v4 format
	$_ = `ping -c1 $host`;
	if(/PING/) {
            ($c1,$c2,$c3,$ignore) = split(/\s+/);
            ($c1,$ip,$ignore) = split(/[\(\)]/, $c3);
	}
	
	#ip address retrieval in v4 failed.Try retrieving using the host command
	if($ip eq "" || $ip eq "127.0.0.1")
	{
	    my $lc_all_original = $ENV{LC_ALL};  #Save the original LC_ALL
	    $ENV{LC_ALL} = "C";
	    @hostOutput = `host -a $host`;
	    $ENV{LC_ALL} = $lc_all_original;     #Restore original LC_ALL
	    
	    $ip = getIPAddressFromHostOutput(\@hostOutput,\$host);
	}
	
	# use ping6 to retrieve the ipaddress
	if($ip eq "" )
	{
	    $_ = `ping6 -n  -c1 $host`;
	    if(/PING/) 
	    {
		($c1,$c2,$c3,$ignore) = split(/\s+/);
		($c1,$ip,$ignore) = split(/[\(\)]/, $c2);
	    }
	}
    }
    
    $os_release_level = trim($os_release_level);
    
    chomp($upsince = `who -b`);
    if ($os =~ m/Linux/i)
    {
	#Linux
	chomp($updata = `grep btime /proc/stat`);
	if ($updata =~ m/btime/i)
	{
	    #/proc/stat contains btime
	    #Should work for most distros
	    #print "DEBUG: using btime from /proc/stat\n";
	    my @btime_data = split(/ /, $updata);
	    ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)= localtime($btime_data[1]);
	    # localtime returns year from 1900 and month in range of 0-11
	    $uptime = sprintf('%04d-%02d-%02d %02d:%02d:%02d',($year+1900),($mon+1),$mday,$hour,$min,$sec);
	}
	elsif ($upsince =~ /system boot/i)
	{
	    #Linux, but /proc/stat doesn't contain btime, so checking `who -b` formats
	    $upsince =~ s/^\s+//; #remove leading whitespaces
	    $upsince =~ s/\s+$//; #remove trailing whitespace
	    if ($upsince =~ m/system boot[\s]+\D+ \d{1,2} \d{1,2}:\d{1,2}$/)
	    {
		#system boot  Oct 26 18:06
		#system boot[\s]+\D+ \d{1,2} \d{1,2}:\d{1,2} 
		#currently seen in EL4
		#print "DEBUG: using who, format 1\n";
		$uptime = getUptimeFormat1($upsince);
	    }
	    elsif ($upsince =~ m/system boot[\s]+\d{1,4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2}$/)
	    {
		#system boot  2008-11-20 12:49
		#system boot[\s]+\d{1,4}-\d{1,2}-\d{1,2} \d{1,2}:\d{1,2}     
		#currently seen in EL5
		$uptime = getUptimeFormat2($upsince);
		#print "DEBUG: using who, format 2\n";
	    }
	    else
	    {
		#Unsupported - `who -b` works, but new format encountered
		$uptime = "2008-00-00 00:00:00";
	    }
	}
	else
	{
	    #Unsupported - neither /proc/stat nor `who -b` working
	    $uptime = "2009-00-00 00:00:00";
	}
    }
    else
    {
	#Other unix operating systems
	if ($upsince =~ /system boot/i)
	{
	    #print "DEBUG: using who, format 1\n";
	    $uptime = getUptimeFormat1($upsince);
	}
	else
	{
	    #Unsupported Unix platform
	    $uptime = "2000-00-00 00:00:00";
	}
    }
    #truncating the properties to MAX_LEN supported on the OMS
    if( length $os_release_level > $MAX_PROP_LEN)
    {
	#EMD_PERL_WARN("Length of os_release_level has crossed $MAX_PROP_LEN, truncating. value=$os_release_level");  
	$os_release_level = substr $os_release_level,0,$MAX_PROP_LEN;
    }
    
    if( length $patchlevel > $MAX_PROP_LEN)
    {
	#EMD_PERL_WARN("Length of patchlevel has crossed $MAX_PROP_LEN, truncating. value=$patchlevel");
	$patchlevel       = substr $patchlevel,0,$MAX_PROP_LEN; 
    }
}

my $targetversion,$distribution;

$targetversion = getTargetVersion();
$distribution  = getDistribution();

# Detailed information about the implementation of bug:10136591 is provided in "http://files.oraclecorp.com/content/MySharedFolders/ST%20Functional%20Specs/EM%20GC%2011ngR1/Cloud%20Management//Target%20Versioning/Target%20Versioning.doc"

# targetversion and distribution will be null for platforms other than linux for now.

print "em_result=$os|$os_release_level|$patchlevel|$platform|$uptime|$ip|$targetversion|$distribution\n";

sub getIPAddressFromHostOutput()
{
    my @lHostOutput  = @{@_[0]};
    my $lHostName  = ${@_[1]};
    my $ipaddress  = "";
    my $is_answer_section = 0;
    my $is_auth_section = 0;
    foreach $line (@lHostOutput)
    {
	#print $line;
	if ($line =~ /ANSWER SECTION/)
	{
	    #print "Matches ANSWER SECTION\n";
	    $is_answer_section = 1;
	    next;
	}
	
	if ($line =~ /AUTHORITY SECTION/)
	{
	    #print "Matches AUTHORITY SECTION\n";
	    $is_auth_section = 1;
	    last;
	}
	
	# search on the ANSWER SECTION only
	if(	$is_answer_section == 1 && $is_auth_section != 1)
	{
	    chomp ($line);
	    chomp ($lHostName);
	    if($line =~ m/^$lHostName/)
	    {
		
		my @tokens = split (/\s+/ ,$line);
		# take the last token as the ip address
		$ipaddress = $tokens[$#tokens];
	    }
	}
    }
    return $ipaddress;
}

sub getDistribution
{
    my $distribution = "";
    my $fileContent;

    if($os eq "Linux")
    {
        if ( -r "/etc/SuSE-release" )
        {
	    # Example :  
	    #  SUSE Linux Enterprise Server 10.2 (x86_64) 
	    #
	    # Distribution = SUSE Linux Enterprise Server

            $fileContent = `cat /etc/SuSE-release | tr '\n' ' ' `;

	    # The text till the first occurence a digit is stripped and saved as distribution.
            if ( $fileContent =~ m/(^[\w\s]*)[\s]+[\d]+[\s\S]*/)
            {
                $distribution = $1;
            }
        }
        elsif ( -r "/etc/oracle-release" )
        {
            $fileContent = `cat /etc/oracle-release | tr '\n' ' ' `;
            if ($fileContent =~ m/^([\w\s]*)release/i )
            {
                $distribution = $1;
	    }
        }
        elsif( -r "/etc/enterprise-release" )
        {
            # Example:
            #  Enterprise Linux Enterprise Linux AS release 4 (October Update 8)
	    #
	    # Distribution = Enterprise Linux Enterprise Linux AS
	    #

            $fileContent = `cat /etc/enterprise-release | tr '\n' ' ' `;

	    # The text till the occurance of the word 'release' is stripped and saved as distribution
            if ($fileContent =~ m/^([\w\s]*)release/i )
            {
                $distribution = $1;
                $distribution =~ s/Enterprise Linux Enterprise Linux/Enterprise Linux/;
            }
        }
        elsif ( -r "/etc/redhat-release" )
        {
            #Example:
            #  Red Hat Enterprise Linux AS release 4 (Nahant Update 5) -- here the distribution version is 4.5
	    #
	    # Distribution = Red Hat Enterprise Linux AS

            $fileContent = `cat /etc/redhat-release | tr '\n' ' ' `;

            # The text till the occurance of the word 'release' is stripped and saved as distribution
            if ($fileContent =~ m/^([\w\s]*)release/i )
            {
                $distribution = $1;
            }
        }
        elsif ( -r "/etc/UnitedLinux-release")
        {
	    #Example:
	    # UnitedLinux 1.0 (i586) VERSION = 1.0
	    #
	    # Distribution = UnitedLinux
			
	    $fileContent = `cat /etc/UnitedLinux-release | tr '\n' ' ' `;

            # Text till occurence of a number is the distribution	
	    if ( $fileContent =~ m/(^[\w\s]*)[\s]+[\d]+[\s\S]*/)
            {
                $distribution = $1;
            }
	}
        else
        {
            EMD_PERL_WARN("/etc/release file not found");
            return "-";
        }

        if ( $distribution eq "" )
        {
            EMD_PERL_WARN("Unexpected format for distribution : $fileContent");
        }
        EMD_PERL_DEBUG("File content : $fileContent. Distribution = $distribution");
  }
  elsif ( $os eq "AIX")
  {
	$distribution = "IBM";
  }
  elsif ( $os eq "SunOS")
  {
        if ( -r "/etc/release" )
        {
	  my $fileContent = `cat /etc/release | tr '\n' ' ' `;
          if ( $fileContent =~ m/Oracle/)
          {
             $distribution = "Oracle";
          }
          elsif ( $fileContent =~ m/Sun/)
          {
             $distribution = "Sun";
          }
          else
          {
             $distribution = "-";
          }
        }                 
        else
        {
          $distribution = "-";
        }
  }
  elsif ( $os eq "HP-UX")
  {
	$distribution = "HP";
  }
  elsif ($isWindows == 1)
  {
        $distribution = "Microsoft" . " " . $os_release_level;
  }
  else
  {
      EMD_PERL_ERROR("Returning distribution as null for the platform $os");
      return "-";
  }

  return $distribution;
}

sub getTargetVersion
{
    my $targetVersion = "";
    my $fileContent;

    if($os eq "Linux")
    {
        if ( -r "/etc/SuSE-release" )
        {
            # Format:
            #  SuSE Linux 9.2 (i586)
            #  VERSION = 9.2
            #
            # Here - targetVersion = 9.2
            #

            $fileContent = `cat /etc/SuSE-release | tr '\n' ' ' `;

            if ( $fileContent =~ m/VERSION[\s]*=[\s]*([\d]+\.[\d]+)/i ) 
            {
                # To extract targetVersion from the format 'VERSION = 9.2'
                $targetVersion = $1;
            }
            elsif ( $fileContent =~ m/VERSION[\s]*=[\s]*(\d+)/i )
            {
                # To extract targetVersion from the format 'VERSION = 10 PATCHLEVEL = 3'
                $targetVersion = $1;
                if ( $fileContent =~ m/PATCHLEVEL[\s]*=[\s]*(\d+)/i )
                {
                    $targetVersion .= ".$1";
                }
                else
                {
                    $targetVersion .= ".0";
                }
            }
        }
        elsif (-r "/etc/oracle-release" )
        {
	   $fileContent = `cat /etc/oracle-release | tr '\n' ' ' `;
           if ($fileContent =~ m/release[\s]*([\d]+\.[\d]+)/i )
            {
                $targetVersion = $1;
            }
            elsif ($fileContent =~ m/release[\s]*(\d+)/i )
            {
                $targetVersion = $1;
                if($fileContent =~ m/Update[\s]*(\d+)/i )
                {
                    $targetVersion .= ".$1";
                }
                else
                {
                    #If no Update string is found then append with .0 (like 4.0)
                    $targetVersion .= ".0";
                }
            }
        }
        elsif( -r "/etc/enterprise-release" )
        {
            # Format:
            #  Enterprise Linux Enterprise Linux AS release 4 (October Update 8)
            #
            # TargetVersion = 4.8

            $fileContent = `cat /etc/enterprise-release | tr '\n' ' ' `;

            if ($fileContent =~ m/release[\s]*([\d]+\.[\d]+)/i )
            {
                $targetVersion = $1;
            }
            elsif ($fileContent =~ m/release[\s]*(\d+)/i )
            {
                $targetVersion = $1;
                if($fileContent =~ m/Update[\s]*(\d+)/i )
                {
                    $targetVersion .= ".$1";
                }
                else
                {
                    #If no Update string is found then append with .0 (like 4.0)
                    $targetVersion .= ".0";
                }
            }
        }
        elsif ( -r "/etc/redhat-release" )
        {
            #Format:
            #  Red Hat Enterprise Linux AS release 4 (Nahant Update 5) 
            #-- here the target version is 4.5
            #

            $fileContent = `cat /etc/redhat-release | tr '\n' ' ' `;

            if ($fileContent =~ m/release[\s]*([\d]+\.[\d]+)/ )
            {
                $targetVersion = $1;
            }
            elsif ($fileContent =~ m/release[\s]*(\d+)/i )
            {
                $targetVersion = $1;
                if($fileContent =~ m/Update[\s]*(\d+)/i )
                {
                    $targetVersion .= ".$1";
                }
                else
                {
                   #If no Update string is found then append with .0 (like 4.0)
                    $targetVersion .= ".0";
                }
            }
        }
        elsif ( -r "/etc/UnitedLinux-release")
        {
            #Example:
	    # UnitedLinux 1.0 (i586) VERSION = 1.0
	    #
	    # Target version = 1.0 -- extracted from VERSION = <>
            #
			
	    $fileContent = `cat /etc/UnitedLinux-release | tr '\n' ' ' `;

	    if ( $fileContent =~ m/VERSION[\s]*=[\s]*([\d]+\.[\d]+)/i )
            {
                $targetVersion = $1;
            }
            elsif ( $fileContent =~ m/VERSION[\s]*=[\s]*([\d]+)/i )
            {
                $targetVersion = "$1.0";
            }
        }
        else
        {
            EMD_PERL_WARN("/etc/release file not found");
            return "";
        }

        if ($targetVersion eq "")
        {
            EMD_PERL_WARN("Unexpected format for target version : $fileContent");
        }

        # If targetversion doesn't match the format <d>.<d>, then return null.
        if (!($targetVersion =~ m/^\d+\.\d+$/))
        {
            EMD_PERL_WARN("TargetVersion : $targetVersion doesn't match the <a>.<b> format. So, returning null for targetVersion");
            $targetVersion = "";
        }
        else
        {
             # Append '.0.0.0' to make targetversion as 'a.b.c.d.e'
             $targetVersion .= ".0.0.0";
        }
        EMD_PERL_DEBUG("File content : $fileContent. targetVersion = $targetVersion");
  }
  elsif ( $os eq "AIX")
  {
        chomp($targetVersion = `uname -v`);
        chomp($targetVersion .= "." . `uname -r`);
        $targetVersion .= ".0.0.0";
  }
  elsif ( $os eq "SunOS")
  {
        chomp($targetVersion = `uname -r`);
        $targetVersion .= ".0.0.0";

  }
  elsif ( $os eq "HP-UX") 
  {
        chomp($targetVersion = `uname -r`);
        # output is like B.11.23 , here we need to extract 11.23 from the string
        if ($targetVersion =~ m/([\s\.]*)([\d\.]+)/)
        {
           $targetVersion = $2; 
           #count the number of occurences of '.' and based on that append the number of '.0' at the end to convert targetVersion of the format a.b.c.d.e
           my $count = ($targetVersion =~ tr/\.//);
           while($count < 4)
           {
              $targetVersion = $targetVersion . ".0";
              $count++;
           }
        }
  }
  elsif ($isWindows == 1)
  {
        my $command_output = "";
        my $nmefwmi = $ENV{ORACLE_HOME}.'\\bin\\nmefwmi.exe';
        my $args = "WBEM_NAMESPACE=root\\cimv2 WBEM_WQL=\"select version,ServicePackMajorVersion from win32_operatingsystem\" WBEM_WQL_COLUMN_ORDER=\"version,ServicePackMajorVersion\"";
        if (-e $nmefwmi)
        {
          chomp($command_output = `$nmefwmi $args`);
          #Output of nmefwmi command will be like : "version=5.1.2600|servicePackMajorVersion=3"
          #TargetVersion is formulates as version.0.servicePackMajorVersion. In the above case, TargetVersion will be 5.1.2600.0.3
          if ($command_output =~ m/version=([\d\.]+)\|servicePackMajorVersion=(\d*)/i)
          {
              my $tgt_prefix = $1;  #Variable to hold version
              my $tgt_suffix = $2;  #Variable to hold servicePackMajorVersion
              if ($tgt_prefix ne "")
              {
                 if($tgt_prefix =~ m/(\d+\.\d+\.\d+)/) # if matches the format X.X.X
                 {
                   $targetVersion = $1 . ".0"; 
                 }
                 elsif($tgt_prefix =~ m/(\d+\.\d+)/) # if matches the format X.X
                 { 
                    $targetVersion = $1 . ".0.0";                   
                 }
                 elsif($tgt_prefix =~ m/(\d+)/)
                 {
                    $targetVersion = $1 . ".0.0.0";
                 } 

                 if($tgt_suffix ne "") #append servicePackMajorVersion to the last filed
                 {
                     $targetVersion = $targetVersion . "." . $tgt_suffix;
                 }
                 else #if there is error getting the servicePackMajorVersion, just append with .0.0 to be comaptible with a.b.c.d.e format
                 {
                     $targetVersion = $targetVersion . ".0";
                     EMD_PERL_WARN("Unable to get servicePackMajorVersion : $command_output");
                 }
              }
              else
              {
                 EMD_PERL_ERROR("Unable to get target version from command output: $command_output");
                 return "";
              }
          }
          else
          {
              EMD_PERL_ERROR("Unable to get version from nmefwmi command : $command_output");
              return "";
          }
        }
        else
        {
          EMD_PERL_ERROR("nmefwmi.exe not found in this location : $nmefwmi");
          return "";
        }
  }
  else
  {
      EMD_PERL_ERROR("Returning target version as null for $os");
      # Implementation will be done for other platforms
      # For other platforms, return null for now.
      return "";
  }

  return $targetVersion;
}
