#!./bin/perl -w
# 
#  $Header: emagent/sysman/admin/scripts/osm/ecmHomePackager.pl /main/4 2012/04/12 20:46:32 aqazi Exp $
#
# Copyright (c) 2001, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    DESCRIPTION
#      script to drive export and import of oracle product installation
#
#    NOTES
#      - must run in the oracle home directory
#
#    MODIFIED   (MM/DD/YY)
#     kbodkhe    12/18/09  - For bug fix 8917264, setting $ENV{ORACLE_HOME}=$ENV{EMDROOT}
#     kbodkhe    11/28/09  - For bug fix 9156181, adding files from install.excl to the exclude list for Windows case as well
#     kbodkhe    09/14/09  - Changing the untar option for hpux platform
#     kbodkhe    08/27/09  - on HP-UX TRU64 platform, treating status 256 as
#                            non-error
#     amani      05/08/08  - For bug fix 6704959. Adding checks for existence
#                            of tar and compress utiltity
#     amani      02/28/08  - For bug fix 6854159. Ignoring file size change
#                            exit code returned from tar command
#     amani      01/10/08  - Backport amani_coregen from main
#     amani      08/09/07  - Support zip utility. HP POC requirement. Added
#			     extra argument useZIP, which enable to use zip utility
#     makarapu   03/17/06  - Bug 5096532- info exclude file issue 
#     anusharm   02/07/05  - adding 2 to tar exit status 
#     anusharm   09/01/04 -  merging ple changes
#     skumar     08/13/04 - HP, AIX, Tru64 and MAC OS X changes
#     mbhoopat   03/10/04 - linux port 
#     jmansur    02/17/04 - fix bug 3450217 - treat zip "can't read file" as
#                           a warning (exit status 18)
#     nsharma    01/21/04 - /bin/compress to /usr/bin/compress 
#     jmansur    12/05/03 - bug 3278299 - use csh for piped commands so overall
#                           command fails if the 1st command in pipeline fails
#     jmansur    09/19/03 - handle embedded spaces in agent home location
#     jmansur    09/16/03 - quote some args in case they contain spaces
#     jmansur    09/10/03 - windows changes
#     jmansur    09/04/03 - switch to zip/unzip
#     jmansur    06/24/03 - use tar + compress on non-windows platforms
#     jmansur    05/15/03 - use -o (always overwrite) when emunzip
#     jmansur    05/12/03 - use emzip & emunzip, not tar; use sourceExcludes
#     jmansur    03/14/03 - handle empty sourceExcludes
#     jmansur    01/30/03 - update comments etc. 
#     jmansur    01/29/03 - jmansur_ecm-030123-clone-sw
#     jmansur    03/20/02 - creation
# 
#

use strict;
use File::Copy;
require "$ENV{EMDROOT}/sysman/admin/scripts/osm/ecmCloneHome.pl";
#
# some platform-specific commands
#
my $TAR = '/bin/tar';
my $CSH = '/bin/csh';
my $COMPRESS = '/bin/compress';
if ($^O eq "linux")
{
   $COMPRESS = '/usr/bin/compress';
}
my $ZCAT = '/bin/zcat';

if ($^O eq "darwin")
{
    $COMPRESS = '/usr/bin/compress';
    $TAR = '/usr/bin/gnutar';
    $ZCAT = '/usr/bin/zcat';
}

setOutputAutoflush();
#printHeader($0, $#ARGV);

#my $javaHome = $ENV{JAVA_HOME};

$ENV{ORACLE_HOME}=$ENV{EMDROOT};

my $operation = $ARGV[0]; # -export | -import
# archive file path (minus file extenstion), e.g., /tmp/homeArvhive
my $archiveName = $ARGV[1];
my $homeDir = $ARGV[2]; # home's full path, e.g. /private/oracle/ora902db
#Adding useZip, HP POC requirement
my $useZip = "FALSE";
if (defined($ARGV[5])) {
	$useZip = $ARGV[5]; #flag to override use of ZIP when operation is export irrespective of OS
}

print "Use Zip Option :: $useZip\n";


#check for the existence of tar, compress utilities. if not throw appropriate error.
if(!onWindows() && ($useZip eq "FALSE"))
{
    	my $tarLoc = File::Spec -> catfile ( $TAR );	
	if(!(-e $tarLoc))
	{
		abort("Cannot find $TAR.", 1, "The tar utility not found. Please install the tar utility to proceed");	
	}
}
 
my $origDir;
if (onWindows())
{
    chomp($origDir = `cd`);
}
else
{
    chomp($origDir = `pwd`);
}
my $wd = $homeDir;
chdir $wd or abort("cd to '$wd'", $!, "$!");

my $systemCommand = "";
my $cmdStatus = 0;
if ($operation eq "-export")
{
  my $compressLoc = File::Spec -> catfile ( $COMPRESS );
  if(!(-e $compressLoc))
  {
    abort("Cannot find $COMPRESS.", 1, "The compress utility not found. Please install the compress utility to proceed.") unless onWindows();
  }

  if (onWindows())
  {
     my $pathZIP = File::Spec->catfile($ENV{ORACLE_HOME}, "bin", "zip.exe");
      abort("Cannot find zip utility at  $pathZIP.", 1, "The ZIP utility is not found. Please ensure a valid ZIP utility exists at $pathZIP.") unless (-e $pathZIP );
    # files to exclude, iff -export'ing, e.g., *.dbf,*.log
    my $sourceExcludes = $ARGV[3];

    #Trimming the spaces and removing double quotes
    $sourceExcludes =~ s/\"/ /g;
    $sourceExcludes =~ s/^[,\s]+//;
    $sourceExcludes =~ s/[,\s]+$//;

    #Splitting  the excludes
    my @excludePatterns = split(/[ ,]+/, $sourceExcludes);
    my $argument = "";
    #Below conversions are needed to overcome the limitations of info-zip
    foreach my $pattern (@excludePatterns)
    {
        if ( $pattern =~ /^\*/) #Pattern begins with *
        {
        $argument = "$argument $pattern $pattern/* ";
        }
        elsif ( $pattern =~ /\*$/ ) #Pattern ends with *
        {
        $argument = "$argument $pattern */$pattern ";
        }
        else # Remaining cases
        {
        #                       OHdir-file   anysubdir-file  OHdir-dir   anysubdir-dir
        $argument = "$argument $pattern */$pattern  $pattern/*   */$pattern/* ";
        }
    }

    # For bug fix 9156181, passing files from install.excl to the zip exclude list for Windows case
    if (defined($ARGV[6]) && ($ARGV[6] ne 'undef'))
    {
  	my $topLevelComp = $ARGV[6];
    	my $installexclfile = getInstallExclFilePath($homeDir, $topLevelComp);
	if(-e $installexclfile)
    	{
          if(open(EXCLUDE, $installexclfile))
          {
            my @dataContents=<EXCLUDE>;
            close(EXCLUDE);
            for(@dataContents)
            {
              my $data = $_;
              $data = getBackSlashedString($data);
              chomp($data);
	      $argument = "$argument $data";
            }
          }
          else
          {
            main::warning ($!,"Open of $installexclfile failed : $! ");
          }
        }
	
    }

    $sourceExcludes = $argument;

    my $excludeOption = "";
    if (defined($sourceExcludes) && ("" ne $sourceExcludes))
    {
      # quote exclude patterns to avoid shell expansions when zip
      my @excludePatterns = split(/[ ,]+/, $sourceExcludes);
      my $qSourceExcludes = '"' . join('" "', @excludePatterns) . '"';
      $excludeOption = "-x $qSourceExcludes";
    }
    #$systemCommand = getQuotedCommand("$ENV{ORACLE_HOME}\\bin\\zip") .
    #  " -r -S -9 -q \"$archiveName\" * $excludeOption";
    $systemCommand = getQuotedCommand("$ENV{ORACLE_HOME}\\bin\\zip") .
      " -r -S -9 \"$archiveName\" * $excludeOption 1> NUL";
  }
  else
  {
    # file containing list of files that tar should exclude -
    # non-Windows only, iff -export'ing
    my $excludeListFile = $ARGV[4];
    # could follow symbolic links with -h option - fix at dest instead
    if($useZip eq "TRUE")
    {	

	# files to exclude, iff -export'ing, e.g., *.dbf,*.log
	my $sourceExcludes = $ARGV[3];

	#Trimming the spaces and removing double quotes
	$sourceExcludes =~ s/\"/ /g;
	$sourceExcludes =~ s/^[,\s]+//;
	$sourceExcludes =~ s/[,\s]+$//;

	#Splitting  the excludes
	my @excludePatterns = split(/[ ,]+/, $sourceExcludes);
	my $argument = "";
	#Below conversions are needed to overcome the limitations of info-zip
	foreach my $pattern (@excludePatterns)
	{
		if ( $pattern =~ /^\*/) #Pattern begins with *
		{
		$argument = "$argument $pattern $pattern/* ";
		}
		elsif ( $pattern =~ /\*$/ ) #Pattern ends with *
		{
		$argument = "$argument $pattern */$pattern ";
		}
		else # Remaining cases
		{
		#                       OHdir-file   anysubdir-file  OHdir-dir   anysubdir-dir
		$argument = "$argument $pattern */$pattern  $pattern/*   */$pattern/* ";
		}
	}
	$sourceExcludes = $argument;


	my $excludeOption = "";
	if (defined($sourceExcludes) && ("" ne $sourceExcludes))
	{
	  # quote exclude patterns to avoid shell expansions when zip
	  my @excludePatterns = split(/[ ,]+/, $sourceExcludes);
	  my $qSourceExcludes = '"' . join('" "', @excludePatterns) . '"';
	  $excludeOption = "-x $qSourceExcludes";
	}
	
	
	my $pathEx = File::Spec->catfile($ENV{ORACLE_HOME}, "bin", "zip");
	$systemCommand = $pathEx . " -r -1 \"$archiveName\" * $excludeOption 1> /dev/null";
    }
    elsif ($^O eq "aix" or $^O eq "dec_osf")
    {
      # no -X option
      $systemCommand="$CSH -cf '$TAR cpfh - . | $COMPRESS -fv > \"$archiveName\"'";
    }
    elsif ($^O eq "hpux")
    {
      $systemCommand="$CSH -cf '$TAR cpfho - . | $COMPRESS -fv > \"$archiveName\"'";
    }
    else
    {
      $systemCommand="$CSH -cf '$TAR cpfXh - \"$excludeListFile\" . | $COMPRESS -fv > \"$archiveName\"'";
    }
  }
  $? = 0;
  $cmdStatus = echodo($systemCommand);
  my $status = $? >> 8; 
  if (onWindows())
  {
    move($archiveName . ".zip", $archiveName);

    # treat status 18 as non-error - assume "can't read file" is due to
    # temp files in active home (e.g., we've seen this for files like
    # OH/oc4j/j2ee/oc4j_applications/applications/em/em/images/chartCache/
    #   chart0853F488A06172535D28249573480188.gif.gif)
    if ((0 != $status) && (18 != $status))
    {
      abort("export of home", $status, "$!");
    }
    else
    {
      $cmdStatus = 0;
    }
  }
  else
  {
    # treat status 13 as non-error - assume "permission denied" and ignore -
    # assume all cases are like root-owned files that get re-created at dest
    # tbd - there may be other errors that we should swallow or warn about,
    # e.g., if a file changes size while we're tar'ing it
    if( $^O eq "hpux" )
    {
       #for hp platforms, ignore exit code 5-- file size changed.
       if ((0 != $status) && (13 != $status) && (2 != $status) && (5 != $status))
       {
           abort("export of home", $status, "$!");
       }
       else
       {
          $cmdStatus = 0;
       }
    }
    elsif ((0 != $status) && (13 != $status) && (2 != $status))
    {
      abort("export of home", $status, "$!");
    }
    else
    {
      $cmdStatus = 0;
    }
  }
}
elsif ($operation eq "-import")
{
  if (onWindows())
  {
    $systemCommand = getQuotedCommand("$ENV{ORACLE_HOME}\\bin\\unzip") .
      " -o -q \"$archiveName\"";
  }
  else
  { 
    #check for the existence of zcat, if not abort
    my $zcatLoc = File::Spec -> catfile ( $ZCAT );
    if(!(-e $zcatLoc))
    {
      abort("Cannot find $ZCAT.", 1, "The zcat utility not found. Please install the zcat utility to proceed");
    }
    move($archiveName, $archiveName . ".tar.Z");

    #changing xpf to xof to take care of the issue of preserving the permissions of root owned files on hpux
    if ($^O eq "hpux")
    {
      # no -B option
      $systemCommand="$CSH -cf '$ZCAT \"$archiveName.tar.Z\" | $TAR xof -'";
    }
    elsif ($^O eq "dec_osf")
    {
      # no -B option
      $systemCommand="$CSH -cf '$ZCAT \"$archiveName.tar.Z\" | $TAR xpf -'";
    }
    else
    {
      $systemCommand="$CSH -cf '$ZCAT \"$archiveName.tar.Z\" | $TAR xBpf -'";
    }
  }
  $? = 0;
  $cmdStatus = echodo($systemCommand);

#For HP-TRU64 platform, treating status 256 as non-error. Due to the 'p' option, tar operation is trying to preserve file permissions and file owners.
#But for root-owned files, it is unable to preserve owner/group, the tar operation is getting done though. So, ignoring the warning message.
  if ($^O eq  "dec_osf")
  {

    if ( 256 == $cmdStatus )
    {
	$cmdStatus = 0;
    }

  }
  if (!onWindows())
  {
    move($archiveName . ".tar.Z", $archiveName);
  }
}

if (0 != $cmdStatus)
{
  abort("$operation", $cmdStatus >> 8, "$cmdStatus >> 8");
}
#
chdir $origDir or abort("cd to '$origDir'", $!, "$!");
exit 0;
