#  $Header: emagent/sysman/admin/scripts/osudmwrapper.pl /main/1 2010/07/18 00:09:16 jklein Exp $
#
# Copyright (c) 2001, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      osudmwrapper.pl - Wraps udm metric definitions to return the result
#    from the em_result= line
#
#    DESCRIPTION
#      Reads various inputs from stdin, executes command with arguments
#      and reports out, messages and exit codes.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#       njagathe 07/01/10 - Initial version
#

use strict;

require "emd_common.pl";

my %stdinArgs = get_stdinvars();

my $command = $stdinArgs{"command"};
my $args = $stdinArgs{"args"};
my $envArray = $stdinArgs{"envArray"};
my $emFailTag = $stdinArgs{"emFailTag"};
my $emRsltTag = $stdinArgs{"emRsltTag"};
my $emMsgTag = $stdinArgs{"emMsgTag"};
my $scriptErrValue = $stdinArgs{"scriptErrValue"};

EMD_PERL_DEBUG("command=$command");
EMD_PERL_DEBUG("args=$args");
EMD_PERL_DEBUG("envArray=$envArray");
EMD_PERL_DEBUG("emFailTag=$emFailTag");
EMD_PERL_DEBUG("emRsltTag=$emRsltTag");
EMD_PERL_DEBUG("emMsgTag=$emMsgTag");

if($emFailTag eq "")
{
    $emFailTag = "em_failure=";
}
if($emRsltTag eq "")
{
    $emRsltTag = "em_result=";
}
if($emMsgTag eq "")
{
    $emMsgTag = "em_message=";
}
setupEnvPairs($envArray);

open (CMD, "$command $args 2>&1|");
my @rsltLines;
while(<CMD>)
{
    my $linei=$_;
    chomp($linei);
    push(@rsltLines, $linei);
}
close (CMD);
my $exitCode = $?;

my $numLines = @rsltLines;
EMD_PERL_DEBUG("NumLines from command = $numLines");
EMD_PERL_DEBUG("Exitcode = $exitCode");

if($exitCode != 0)
{
    die(processResultLines($emFailTag, \@rsltLines, "\n"));
}
my $rslt = processResultLines($emRsltTag, \@rsltLines, "");
my $msg = processResultLines($emMsgTag, \@rsltLines, "");
print "$rslt|$msg";
exit 0;

sub setupEnvPairs
{
    my($envPairs)=@_;

    chomp($envPairs);
    my $len = length($envPairs);
    my $pos = 0;

    #First find the {
    #Next find the }
    #Split the characters around a =
    #Repeat..

    while($pos < $len) {
	my $lpos = index($envPairs, "{", $pos);
	if($lpos eq -1)
	{
	    last;
	}
	my $rpos = index($envPairs, "}", $lpos);
	if($rpos eq -1)
	{
	    last;
	}
	my $nvpair = substr($envPairs, $lpos+1, ($rpos - $lpos - 1));
        my $eqpos = index($nvpair, "=");
	if($eqpos ne -1)
        {
	    my $name = substr($nvpair, 0, $eqpos);
	    my $val = substr($nvpair, $eqpos+1);
	    $ENV{$name} = $val;
	    EMD_PERL_DEBUG("Setting env $name to $val");
	    $pos = $rpos + 1;
	}
	else
	{
	    last;
	}
    }
}

sub processResultLines 
{
    my ($startsWith, $rsltLinesRef, $lineSep) = @_;
    my @resultLines = @{$rsltLinesRef};
    my $retVal = "";
    my $numLines = @resultLines;
    my $iter = 0;
    for($iter = 0; $iter < $numLines; $iter++) 
    {
        my $linei = $resultLines[$iter];
	if($linei =~ /^$startsWith/)
        { 
            my $slen = length($startsWith);
            my $addstr = substr($linei, length($startsWith));
	    $retVal = $retVal . $addstr . $lineSep;
        }
    }
    return $retVal;
}
