#!/bin/ksh
#
# vsekuboy 10/24/02 Added changes for AIX
#

OS=$(uname -s)

if [[ $OS = "AIX" ]]
then
   MEM=""
   for pid in $@
   do
        RSS=`ps u $pid | tail +2 | awk '{print $6}'`
        if [ ! "$RSS" = "" ]
        then
                MEM="$MEM $RSS"
        fi
   done
   typeset -i sum=0;
   for i in $MEM
   do
        let sum=sum+${i};
   done
   echo "em_result=$sum"
   exit 0
fi


rm -f /tmp/pm.$$
rm -f /tmp/pm1.$$
for pid in $@
do
    /usr/proc/bin/pmap -x $pid > /tmp/pm1.$$
    if [ $? -ne 0 ]
    then
      rm -f /tmp/pm.$$
      rm -f /tmp/pm1.$$
      exit
    fi
    tail -1 /tmp/pm1.$$ >> /tmp/pm.$$
done

cat /tmp/pm.$$ | nawk 'BEGIN{priv=0;shared=0}{priv += $6;if($5 > shared){shared = $5}}END{print "em_result="shared + priv}'

rm -f /tmp/pm.$$
rm -f /tmp/pm1.$$
