#!/usr/local/bin/perl
# 
# $Header: emagent/sysman/admin/scripts/pop_service_stat.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:32:11 pnayak Exp $
#
# pop_service_stat.pl
# 
# Copyright (c) 2003, 2005, Oracle. All rights reserved.  
#
#    NAME
#      pop_service_stat.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#        The Pop service test type should be marked as down only if the "connection"
#        and "login" to the POP service fails 6 consecutive times ( or a user
#        specifiable property ). The initial version will not let the user to 
#        configure the number of times a failure can be allowed for concerns on
#        using large number. 
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vesriniv  07/14/05 - fix status issue 
#    fsalim    07/08/05 - fix4478756
#    fsalim    07/04/05 - To return the error status message 
#    mbisarya  12/10/04 - to modify function definition check_po_login to 
#                         check_pop_login 
#    tjaiswal  11/12/04 - tjaiswal_test_type_impl
#    vesriniv	 11/02/04 - Updated the result to return Txn name and Beacon name
#    vesriniv	 11/02/04 - Modified instance variables to USER input variables
#    gmulchan    07/30/03 - gmulchan_ocsv1_main_merge
#    tjaiswal    04/25/03 - 
#    tjaiswal    04/22/03 - 
#    tjaiswal    04/20/03 - Creation
# 
#use strict;
use Net::POP3;
use Time::HiRes;
use Getopt::Long; # set up to accept user input

#pop parameters

GetOptions(\%cmdLine,
            "BeaconName=s",
            "TxnName=s",
            "numretries=i",
            "retryinterval=i",
            "pop_host=s",
            "pop_user_name=s",
            "pop_password=s");

my $beaconName = $cmdLine{"BeaconName"};
my $txnName = $cmdLine{"TxnName"};
my $pop_host = $cmdLine{"pop_host"};
my $pop_username = $cmdLine{"pop_user_name"};
my $pop_password = $cmdLine{"pop_password"};
my $retryinterval = $cmdLine{"retryinterval"};
my $pop_fail_count = $cmdLine{"numretries"};         

#default
$pop_fail_count = 6 unless (exists  $cmdLine{"numretries"});
$retryinterval = 5 unless (exists  $cmdLine{"retryinterval"});

# metrics

######
# $connect_time
# $login_time
# $open_email_time
####
$total_time = 0;
$connect_time = 0;
$login_time = 0;
$open_email_time = 0;
$errTxt = "Success";

print "Connecting.. $pop_host :: $pop_username\n";

# open a connection to the POP server

$start_time = Time::HiRes::time();

do {

   sleep $retryinterval if $fail_count > 0;

   $status = check_pop_login();
   $fail_count++;
   print "test count = $fail_count, statst = $status\n";
}while ( $fail_count < $pop_fail_count && $status == 0 );


if($status ==1)
  {    
    print "Connect Time = $connect_time\n";
    print "Login Time = $login_time\n";
    print "Open Email Time = $open_email_time\n";
    print "Total Time = $total_time\n";
    printf ("em_result=$txnName|$beaconName|$status|$total_time|$connect_time|$login_time|$open_email_time|$errTxt\n");
}
else
{
    print "Connection failed\n";
    printf ("em_result=$txnName|$beaconName|$status|$total_time|$connect_time|$login_time|$open_email_time|$errTxt\n");
}

#################################################################
# create sub routine
# return value : 1 - login success
#                0 - login fail
#################################################################
sub check_pop_login 
{
   # define $l_status as local variable
   my( $l_status );    

   # connect pop server
   $server = Net::POP3->new( $pop_host );

   # if connection is succeed
    if ($server) 
    {
   
        $l_status = 1;
        $connect_time = Time::HiRes::time() - $start_time;

        # login, by default selects INBOX
        $start_time = Time::HiRes::time();
        $server->login( $pop_username, $pop_password );
        print "login done\n";
        $login_time = Time::HiRes::time() - $start_time;
    
        ($num_messages, $size) = $server->popstat();
        print "Number of messages in the inbox = $num_messages\n";
        print "Size of the mailbox = $size\n";

        # decide if this is a metric error or just status = down ?
        if (! defined  ($num_messages))
        {
            #print "em_error=Invalid Login\n";
            #$server->quit();
            #exit 1;
            $errTxt = "Login Failed - Please check the username and password"; 
            # regard this as status down
            print "Login failed\n";
            $status = 0;
            return $status;
            #print ("em_result=%s|%s|%d\n",$txnName, $beaconName, $status);        
            #exit 0;
        }

        # Read the first message
        $start_time = Time::HiRes::time();
        $lines = $server->get( 1 );
        $open_email_time = Time::HiRes::time() - $start_time;

        # close the connection
        $server->quit();

        $total_time = $connect_time + $login_time + $open_email_time;

        # Important : Convert to milliseconds.
        $connect_time = toMilliSec($connect_time) ;
        $login_time = toMilliSec($login_time);
        $open_email_time = toMilliSec($open_email_time) ;   
        $total_time = toMilliSec($total_time); 
    } # end of login fail
    else 
     {
       $errTxt = "Could not connect to pop server, please check machine name and port number";  
       # fail to connect imap
       print "Connection failed\n";
       $l_status = 0;
     }        
     return $l_status;
   }

sub toMilliSec 
{
    my ( $time_in_sec) = @_;
    return $time_in_sec * 1000;
}
