#!/bin/sh
#
# $Header: emagent/sysman/admin/scripts/purgeCollectionsOid.sh /st_emagent_10.2.0.1.0/1 2009/03/10 05:32:11 pnayak Exp $
#
# purgeCollectionsOid.sh
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      purgeCollectionsOid.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ggilchri    11/15/01 -
#    ggilchri    11/15/01 - Creation
#
ORACLE_HOME=$1
export ORACLE_HOME

ORACLE_SID=$2
export ORACLE_SID

PATH=$1/bin:$PATH
export PATH

TNS_ADMIN=$1/network/admin
export TNS_ADMIN

LD_LIBRARY_PATH=$ORACLE_HOME/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

NLS_LANG=AMERICAN_AMERICA.UTF8
export NLS_LANG

if [ "$4" = "all" ] ; then
  # purge dead instances and all collections
  $ORACLE_HOME/bin/sqlplus /nolog << EOF
  connect ods / $3
  delete from ds_attrstore where entryid in \
  (select entryid from ct_tombstone where rdn like \
  'cn=instance%' and parentdn = 'cn=subregistrysubentry,cn=osdldapd,');
  delete from ct_tombstone where entryid in \
  (select entryid from ct_tombstone where rdn like \
  'cn=instance%' and parentdn = 'cn=subregistrysubentry,cn=osdldapd,');
  truncate table P1_DS_ATTRSTORE;
  truncate table P1_DS_BATTRSTORE;
  truncate table P1_CT_DN;
  truncate table P1_CT_OBJECTCLASS;
  truncate table P1_CT_ORCLEVENTTYPE;
  truncate table P1_CT_ORCLEVENTTIME;
  truncate table P1_CT_ORCLLDAPINSTANCEID;
  truncate table P1_CT_ORCLLDAPPROCESSID;
  commit;
  EOF
else
  # purge collections but leave the dead instances
  # last parameter disregarded
  $ORACLE_HOME/bin/sqlplus /nolog << EOF
  connect ods / $3
  truncate table P1_DS_ATTRSTORE;
  truncate table P1_DS_BATTRSTORE;
  truncate table P1_CT_DN;
  truncate table P1_CT_OBJECTCLASS;
  truncate table P1_CT_ORCLEVENTTYPE;
  truncate table P1_CT_ORCLEVENTTIME;
  truncate table P1_CT_ORCLLDAPINSTANCEID;
  truncate table P1_CT_ORCLLDAPPROCESSID;
  commit;
  EOF
fi

