#!/bin/sh
#
# $Header: emagent/sysman/admin/scripts/restartoidserver.sh /st_emagent_10.2.0.1.0/1 2009/03/10 05:32:11 pnayak Exp $
#
# restartoidserver.sh
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      restartoidserver.sh - This script restarts oidldapd server
#
#    DESCRIPTION
#	usage: restartoidserver.sh <connectString> <instanceNumber> 
#
#
#	connectString: Connect String of the database
#
#       instanceNo   : Instance number of the server to start.  This should be a 
#                      number whose value MUST be > 0 and <= 1000. 
#
#	Note:  Please make sure that environment variable $ORACLE_HOME is set, before
#	       running this script.
#
#              This script has been written for the default configurations.  User needs
#              to edit it as per his requirements.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xshi        09/13/01 - 
#    xshi        09/13/01 - Creation
#

if [ $# -eq 3 ]
then
  sleeptime=0
else
  sleeptime=$3
fi

LOGFILE=/tmp/oid$$.log

$ORACLE_HOME/bin/oidctl connect=$1 server=OIDLDAPD instance=$2 restart >> $LOGFILE 2>&1 

sleep $sleeptime
exit 0


