#!/bin/sh
#
# $Header: emagent/sysman/admin/scripts/startodiserver.sh /st_emagent_10.2.0.1.0/1 2009/03/10 05:32:24 pnayak Exp $
#
# startodiserver.sh
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      startodiserver.sh - This script starts oidmon and then starts odisrv server
#
#    DESCRIPTION
#	usage: startodiserver.sh <connectString> <instanceNumber> [<sleepTime>] 
#
#
#	connectString: Connect String of the database
#
#       instanceNo   : Instance number of the server to start.  This should be a 
#                      number whose value MUST be > 0 and <= 1000. 
#
#       sleepTime : Specifies for ODI Server, the time in number of seconds,
#                   for it to come to a steady state after startup
#
#	Note:  Please make sure that environment variable $ORACLE_HOME is set, before
#	       running this script.
#
#              This script has been written for the default configurations.  User needs
#	       to edit it as per his requirements.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xshi        09/13/01 - odi server
#    xshi        09/13/01 - Creation
#

if [ $# -eq 3 ]
then
  sleeptime=0
else
  sleeptime=$3
fi

LOGFILE=/tmp/odi$$.log

$ORACLE_HOME/bin/oidmon connect=$1 sleep=10 start >> $LOGFILE 2>&1 
sleep 30

$ORACLE_HOME/bin/oidctl connect=$1 server=ODISRV instance=$2 start >> $LOGFILE 2>&1 

sleep $sleeptime
exit 0


