#!/bin/sh
#
# $Header: emagent/sysman/admin/scripts/startoidserver.sh /st_emagent_10.2.0.1.0/1 2009/03/10 05:32:24 pnayak Exp $
#
# startoidserver.sh
#
#  Copyright (c) Oracle Corporation 2001. All Rights Reserved.
#
#    NAME
#      startoidserver.sh - This script starts oidmon and then starts oidldapd server
#
#    DESCRIPTION
#	usage: startoidserver.sh <connectString> <instanceNumber> [<sleepTime>] 
#
#
#	connectString: Connect String of the database
#
#       instanceNo   : Instance number of the server to start.  This should be a 
#                      number whose value MUST be > 0 and <= 1000. 
#
#       sleepTime : Specifies for OID Server, the time in number of seconds,
#                   for it to come to a steady state after startup
#
#	Note:  Please make sure that environment variable $ORACLE_HOME is set, before
#	       running this script.
#
#              This script has been written for the default configurations.  User needs
#	       to edit it as per his requirements.
#
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    xshi        09/13/01 - 
#    xshi        09/13/01 - Creation
#

if [ $# -eq 3 ]
then
  sleeptime=0
else
  sleeptime=$3
fi

LOGFILE=/tmp/oid$$.log

$ORACLE_HOME/bin/oidmon connect=$1 sleep=10 start >> $LOGFILE 2>&1 
sleep 30

$ORACLE_HOME/bin/oidctl connect=$1 server=OIDLDAPD instance=$2 start >> $LOGFILE 2>&1 

sleep $sleeptime
exit 0


