#!/bin/sh

#
#
#  NAME
#       stopCollectionOid.sh - This script stops collection of Server manageability information
#	     		         for LDAP server.  It takes three mendatory parameters namely port 
#				 number of LDAP server, bind DN and its password.  If optional 
#				 parameter host name is not provided, it is assumed that this 
#				 script is running on the same host where LDAP server is
#				 running.  Otherwise, hostname parameter too will have to be passed
#				 to the script. 
#
#  DESCRIPTION
#	usage: stopCollectionOid.sh <oraHome> <port#> <password> [<hostName>]
#       NOTE: to set the actual bind DN for this operation preset the env
#       variable "BIND_DN"
#
#	hostName: Host name where LDAP server is running
#
#	port#: Port number of LDAP server
#
#	bindDN: DN performing necessary bind 
#
#	password: bind DN password 
#
#	Note:  Please make sure that environment variable $ORACLE_HOME is set, before
#	       running this script.
#	       The information gathering periodicity has been kept at at its default value,
#	       which is 60 (1 hour).
#	       User needs to edit it as per his requirements by modifying the value for 
#	       the attribute orclStatsPeriodicity.
#

ORACLE_HOME=$1
export ORACLE_HOME

PATH=$1/bin:$PATH
export PATH

TNS_ADMIN=$1/network/admin
export TNS_ADMIN

LD_LIBRARY_PATH=$ORACLE_HOME/lib:$LD_LIBRARY_PATH
export LD_LIBRARY_PATH

NLS_LANG=AMERICAN_AMERICA.UTF8
export NLS_LANG

if [ $# -lt 3 ]
then
  echo "usage: stopCollectionOid.sh <oraHome> <port#> <password> [<hostName>]"
  exit 1
fi

if [ $# -eq 4 ]
then
  hostName=$4
fi

bindDN=$BIND_DN
oraHome=$1
portNo=$2
bindPw=$3

if [ $# -eq 4 ]
then
  eval $oraHome/bin/ldapmodify -h $hostName -p $portNo -D \"$bindDN\" -w $bindPw -v << LDAPMODIFY_END 
dn:
changetype:modify
replace: orclStatsPeriodicity
orclStatsPeriodicity:60
-
replace: orclStatsFlag
orclStatsFlag:0
LDAPMODIFY_END
else
  eval $oraHome/bin/ldapmodify -p $portNo -D \"$bindDN\" -w $bindPw -v << LDAPMODIFY_END
dn:
changetype:modify
replace: orclStatsPeriodicity
orclStatsPeriodicity:60
-
replace: orclStatsFlag
orclStatsFlag:0
LDAPMODIFY_END
fi

exit 0

