#!/usr/local/bin/perl
# 
# $Header: emll/plugins/extensions/default/bug14667342/agent/scripts/update_info.pl /main/1 2012/11/15 02:06:36 ckalivar Exp $
#
# update_info.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      update_info.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ckalivar    10/25/12 - Creation
#

use strict;
use hostUtil;
use hostOSD;

my $os;
#if its not windows
if ( !(($^O =~ "MSWin32") || ($^O =~ "Windows")) )
{
  chomp ($os = `uname -s`);
  #if its only Solaris(SunOS) then
  my $versionRelease = getOSRelease();
    # getOSRelease will give you baseversion-release info, we just need base version
  my $baseVersion = (split("-",$versionRelease))[0];
  my $subVersion = (split( /\./, $baseVersion))[1];
  #if its only Solaris(SunOS) then
  if ( $os eq "SunOS" && $subVersion>9)
  {
    my $update_level="";
    my $SOLARIS_10_PATCH_FILE='/var/sadm/install_data/rec_patchset_version';
    my $PATCH_ENTRY='recpatchset';
    my $line;
    my $PKG_BIN='/usr/bin/pkg';
    if(-e $PKG_BIN && $subVersion>10)
    {
      my $cmd ='/usr/bin/pkg list -H entire';
      my $output = `$cmd`;
      $update_level = (split(' ',$output))[1];
    }
    if ( -e $SOLARIS_10_PATCH_FILE && $subVersion==10)
    {
      if (open (LINES, "<$SOLARIS_10_PATCH_FILE") )
      {
        while ($line = <LINES>)
        {
          chomp($line);
          if ($line =~ /^$PATCH_ENTRY/)
          {
            $update_level = (split('=',$line))[1];
            chomp($update_level);
          }
        }
      }
    }
    $update_level=hostUtil::trim($update_level);
    print "em_result=$update_level|$baseVersion\n";
  }
}
 
