# $Header: emagent/sysman/admin/scripts/urlStats.pl /st_emagent_10.2.0.1.0/1 2009/03/10 05:32:38 pnayak Exp $
#
# urlStats.pl
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      urlStats.pl - gets apache web server statistics from
#                    the web server status page
#
#    DESCRIPTION
#      urlStats.pl <machine_name> <port> <status_url> <list of stats to get>
#
#      where:
#         <machine_name> is the name of the machine that we want to get stats
#                        from.
#         <port> the port on <machine_name> on which the web server is 
#                listening
#         <status_url> the url of the status page for this web server.
#         example:  if the url is http://foo:9090/fighter
#                   then <status_url> = "/fighter"
#         <list of stats to get> is a space separated list of stats to get.
#                                they must be one of the following:
#             req,idle,cpu,rps,bps,bpr,numX,totK,uptm
#
#    returns: a "|" separated list of values for each member of 
#             <list of stats to get>.  
#
#    NOTES
#
#
#    MODIFIED   (MM/DD/YY)
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    aaitghez    06/28/01 - bad concat fix.
#    aaitghez    06/19/01 - removing strict clause.
#    aaitghez    06/01/01 - adding debug and common commands.
#    aaitghez    05/30/01 - adding reuire clauses.
#    aaitghez    05/29/01 - removing example.
#    aaitghez    05/29/01 - adding comments.
#    aaitghez    05/23/01 - replacement for urlStats.tcl
#    aaitghez    05/23/01 - Creation
# 


require "emd_common.pl";
require HTTP::Request;
require LWP::UserAgent;

my $machine;
my $port;
my $status;
my $ua;
my $url;
my $request; 
my $response;
my @lines;
my $value;
my $result;
my $attr;

($machine, $port, $status) = @ARGV;

$ua = LWP::UserAgent->new;
#form request
$url = "http://".$machine.":".$port.$status;

$request = HTTP::Request->new(GET => '$url');

#get response
$response = $ua->request($request);
#EMD_TRACE("Got response from $machine");

#check for error
if($response->is_error) {
    # some error occured..let's inform the EDM about it
    print "em_error=Error occured getting urlstats\n";
#    EMD_DEBUG("Error occured getting $url: $!.\n", "$machine");
    exit;
} else {
    # no error
#    EMD_TRACE("Parsing URL.\n");
    @lines = split(/\n/,$response->content);
    foreach $line (@lines) {
	($name, $value) = split(/:/, $line);
	$value =~ s/^(\s)*//;
	#check what the user wanted to get from the status page
	SWITCH: {
	    if($name eq "BusyServers") {$attr{"req"} = $value;}
	    if($name eq "IdleServers") {$attr{"idle"} = $value;}
	    if($name eq "CPULoad") {$attr{"cpu"} = $value;}
	    if($name eq "ReqPerSec") {$attr{"rps"} = $value;}
	    if($name eq "BytesPerSec") {$attr{"bps"} = $value;}
	    if($name eq "BytesPerReq")  {$attr{"bpr"} = $value;}
	    if($name eq "Total Accesses") {$attr{"numX"} = $value;}
	    if($name eq "Total kBytes") {$attr{"totK"} = $value;}
	    if($name eq "Uptime") {$attr{"uptm"} = $value;}
	}
    }

    # form output
    # note that i starts from 3 because we
    # are looking at the arguments which represent
    # server values to fetch
    # EMD_TRACE("Forming output.\n");
    for($i = 3; $i < @ARGV; $i++) {	
	if(exists $attr{@ARGV[$i]}) {
	    $result .= $attr{@ARGV[$i]}."|";
	} else {
	    # if the value was not available place 0
	    #perhaps it was a wrong argument
	    $result .= "0|";
	}
    }
}
chop($result);
print $result."\n";
