#!/bin/ksh
#
# Usage weblistener_resp.ksh EnvFile LsnrName
#
# where:
# 
#   EnvFile : Fully qualified environment file
#   LsnrName: Name of the reports listener
#
#
# To use owsctl, you must have the following environment variables set in $EnvFile:
#
# ORAWEB_HOME - Absolute path where Oracle Web Application Server is installed. 
#               This should be $ORACLE_HOME/ows/3.0 for release 3.0. ORACLE_HOME 
#               is the absolute path where you install Oracle products.
# ORAWEB_SITE - This is the site name for the Oracle Web Application Server.
# ORACLE_HOME - Must be set to where you installed your Oracle products.
#


EnvFile=$1
LsnrName=$2

. $EnvFile                     # source environment file

ret_value=1

# check WRB process
if (`owsctl status wrb 2>&1 |grep DOWN >/dev/null`)
then
    ret_value=0
fi

# check ADMIN process
if (`owsctl status admin 2>&1 |grep DOWN >/dev/null`)
then
    ret_value=0
fi

# check if second argument is non-zero length
if [[ -n $2 ]]
then
    web_lsnr_process=$2
    if (`owsctl status ${web_lsnr_process} 2>&1 |grep DOWN >/dev/null`)
    then
       ret_value=0
    fi
fi

echo "em_result=$ret_value"
