# $Header: emdb/sysman/admin/scripts/alertlogViewer.pl /main/10 2011/10/26 07:20:35 rkunnamp Exp $
#
# alertlogViewer.pl
# 
# Copyright (c) 2002, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      alertlogViewer.pl - show the last n bytes of an alert log file
#
#    DESCRIPTION
#      Given oracle home, directory containing Oracle alert log file, SID,
#      alertlogViewer dumps the last given size of the content of the alert log file
#
#    NOTES
#      (none)
#
#    MODIFIED   (MM/DD/YY)
#      rkunnam 10/17/11 - bug 13075970
#      rkunnam 07/29/11 - bug 12720606 fix
#      rkunnam 12/01/10 - bug-10286010 fix transaction .
#      rtakeis 07/03/07 - bug6141778, alertLogViewerError03 appears 
#                         in alertlog contents
#      ychan   01/20/05 - Fix filter 
#      ychan   01/18/05 - Add filter support 
#      jsoule  11/06/02 - don't assume '?' in background_dump_dest
#      xxu     06/24/02 - remove /usr/local/bin/perl
#      hjchu   01/30/02 - Creation
#

use strict;
use Time::Local;
use HTTP::Date;

require "alertlog_util.pl";

# Command Line Arguments
my $argnum = @ARGV;

my $OracleHome = shift(@ARGV);
my $dest = shift(@ARGV);       # Absolute directory containing (log) file (oracle home prepended)
my $SID = shift(@ARGV);        # Database SID 
my $sizeToView = shift(@ARGV); # The last <sizeToView> bytes to view

my $stime;      # start time filter
my $etime;      # end time filter

if ($argnum > 4)
{
    $stime=shift(@ARGV);
    $etime=shift(@ARGV);
}
# End Arguments

my $logFile = get_absolute_alert_log_filename($dest, $OracleHome, $SID);

if(!open(FH, "$logFile"))  
{
    print "em_alertLogViewerError01:\n$logFile\n";
    exit 0;
}


seek(FH,0,2);  # go directly to EOF

my $fileSize = tell(FH);
my $startPoint = $fileSize - $sizeToView;

if($startPoint < 0)
{
    $startPoint = 0; 
}

if(!seek(FH, $startPoint, 0))  
{
    print "em_alertLogViewerError02:\n$logFile\n";
    exit 0;
}

my $bufferSize = 1000; # size of read buffer in bytes
my $record;

if ( (!defined($stime) &&  !defined($etime)) || ($stime eq '0' && $etime eq '0'))
{
    while(<FH>)
    {
        #read(FH, $record, $bufferSize) || die "can't read $logFile: $!";
        if(!read(FH, $record, $bufferSize))  
        {
            my $fileNameLen = length $logFile;
            my $fileNameLenVal;
            if ($fileNameLen < 9)
            {
               $fileNameLenVal = "  " . $fileNameLen;
            }
            elsif ($fileNameLen < 99)
            {
               $fileNameLenVal = " " . $fileNameLen;
            }
            else
            {
               $fileNameLenVal = $fileNameLen;
            }
            print "$logFile" . "$fileNameLenVal" . "em_alertLogViewerError03:";
            exit 0;
        }    
        print $record;
    }
}
else
{
    my $secs;
    my $found=0;

    # start time
    my $stimesec;
    if ($stime eq '0')
    {
        $stimesec = 0;
    }
    else
    {
        my @startlist=split(':', $stime);
        $stimesec = timelocal(@startlist);
    }        
    
    # end time
    my $etimesec;
    if ($etime eq '0')
    {
        $etimesec = 0;
    }
    else
    {
        my @endlist=split(':', $etime);
        $etimesec = timelocal(@endlist);
    }    

    while(<FH>)
    {
        $record = $_;   
	my $isRecdTimeStmp=0;
	my $newtime="";   
        
        if ($found == 0 ||  $etimesec != 0)
        {
	    if($record =~ m/(\w+) (\w+)( |  )(\d+) (\d+):(\d+):(\d+)(.*)(\d+)$/ )
            {	
		my @timearray = split(' ', $record);
                my $arraylen = @timearray;
		$newtime = join " ", $timearray[0],$timearray[1],$timearray[2],$timearray[3],$timearray[$arraylen-1];
		$isRecdTimeStmp=1;
	    }
	    if($isRecdTimeStmp)
	    {
	    $secs=str2time($newtime);
	    }
	    else
	    {
	    $secs = str2time($record);
	    }   
      
    
            if (defined $secs)
            {
                if ($secs >= $stimesec && ($secs <= $etimesec || $etimesec == 0))
                {        
                    $found = 1;
                }
                elsif ($secs > $etimesec && $etimesec != 0)
                {
                    last;
                }        
            }                  
        }           
    
        if ($found == 1)
        {         
            print "$record";
        }  
    }     
}

close FH;  
