# $Header: emdb/sysman/admin/scripts/alertlog_find.pl /st_emdbgc_10.2.0.1.0/1 2009/03/11 06:07:49 pnayak Exp $
#
# alertlog_find.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      alertlog_find.pl - identify the absolute filename of the alert log file
#
#    DESCRIPTION
#      Given the background_dump_dest, oracle_home, and oracle_sid, determine
#      the complete filename of the alert log file.
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsoule      12/09/04 - jsoule_full_alertlog_parametrization
#    jsoule      11/29/04 - Creation
# 

use strict;
use Time::HiRes;

require "emd_common.pl";
require "alertlog_util.pl";

my $backgroundDumpDest = shift(@ARGV);         # background_dump_dest

my $oracle_home = $ENV{EM_TARGET_ORACLE_HOME}; # oracle_home
my $SID         = $ENV{EM_TARGET_ORACLE_SID};  # oracle_sid

my $alert_log_directory = get_alert_log_directory($backgroundDumpDest, $oracle_home);
unless (-d $alert_log_directory)
{
    # abort if the alert log parent directory could not be found
    EMAGENT_PERL_ERROR("Unable to locate alert log file's directory.");
    exit 1;
}
my $alert_log_file = get_alert_log_filename($SID, $alert_log_directory);
if (!$alert_log_file)
{
    # silently quit if the alert log file has been removed
    EMAGENT_PERL_INFO("The alert log is absent.");
    print "em_result=[MISSING_LOG]\n";
    exit 0;
}
my $absolute_alert_log = compose_absolute_alert_log_filename($alert_log_directory, $alert_log_file);

print "em_result=$absolute_alert_log\n";

exit 0;
