#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/archivetracefile.pl /st_emdbgc_10.2.0.1.0/1 2008/08/04 07:07:37 anosriva Exp $
#
# archivetracefile.pl
# 
# Copyright (c) 2006, 2008, Oracle. All rights reserved.
#
#    NAME
#      archivetracefile.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#       This script will archive the files specified by given pattern 
#       in given directory whose modified date is older than given age
#       into the destination host&directory.
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    anosriva    07/28/08 - 
#    prapatil    07/08/08 - 
#    ganessub    01/20/08 - PDP Changes.
#    ganessub    11/13/06 - Bug 5622272 fix.
#    ganessub    07/05/06 - 
#    armaity     06/25/06 - 
#    ganessub    04/12/06 - Creation.
# 
#

use strict;
use Time::Local;
use HTTP::Date;
use Fcntl qw (:flock);
use File::Copy;
#use Net::FTP;

require "archivepurge_util.pl";

# Command Line Arguments
my $argnum = @ARGV;

my $trcfiles       = shift(@ARGV);
my $archiveAge = shift(@ARGV);   # number of days older need to be archived
my $destdir   = shift(@ARGV);
my $purgeflag   = shift(@ARGV);
my $sourcehost   = shift(@ARGV);
my $desthost   = shift(@ARGV);
my $jarCmd     = shift(@ARGV);
my $mode       = shift(@ARGV);
# End Arguments
#print $jarCmd;
#print $mode;
my $trueflag = "true";
if ( $mode eq 'EXTRACT')
{
#  print "inside dest command";
  chdir($destdir) or die "Can not find Destination Directory:$destdir";
  binmode STDIN;
  open SPOOLER ,"| $jarCmd -x" or die "Can't fork: $!";
  binmode SPOOLER;
  local $SIG{PIPE} = sub { die "spooler pipe broke" };
  my $BUFSIZE = 32768;
  my $data;
  my $bytes;
  while(($bytes = read(STDIN, $data, $BUFSIZE)) > 0)
  {
    print SPOOLER $data;
  }
  close SPOOLER or die "bad spool: $! $?";
      if ($purgeflag eq $trueflag)
      {
         print "Archived and Purged Successfully!";
      }
      else
      {   print "Archived Successfully!";
      }
      exit 0;
}
# Check if timezone exist if not set to UTC as it is required by DateManip module.
my $timez = $ENV{"TZ"};
#print "Host Time Zone is : $timez\n";

if ( $timez eq '') {
#   print "Warning:Local Timezone is not set on this host, hence UTC is assumed as a timezone.";
#   print "        Set TZ environment variable if you want correct timezone.";
   &Date_Init("TZ=UTC");
}

my $file;

#get files based on the pattern
my @files = glob($trcfiles);
#closedir(DIR);
my $fileseparator      = do {
	if(    $^O =~ m/MSWin32/ ) { '\\' }
	else                       { '/'  }
	};

if (length(@files) <= 0)
{
  print "\nNo trace files matched to the given archival criteria!";
  exit 0;
}
my $filename;
my $destfilename;
my $ftp;
#if ($sourcehost eq $desthost)
#{
#    #print "same host so ftp avoided.";
#}
#else
#{
#     # Create a new Net::FTP object, changing the
#     # timeout to 60 seconds
#     $ftp = Net::FTP->new($desthost, Timeout => 60) 
#               or die "Could not connect to $desthost. Archive operation aborted.";   
#     $ftp->login($destuserid,$destuserpwd) 
#      or die "Can't login ($desthost):" . $ftp->message;  
#     # Change the working directory 	
#     $ftp->cwd($destdir) or 
#      die "Can't change directory ($destdir) in host $desthost:" . 
#        $ftp->message;  
#}
my $localtstamp =  getlocaltimestamp();
my $dotc = ".";
my $archcnt = 0;
my $dispfile;
my $jarArg = "";
foreach $file (@files) {
   if (-M $file >= $archiveAge)
   {
          if ($archcnt eq 0)
          {
            my $dirName = substr($file,0,rindex($file,$fileseparator));
            chdir($dirName);
      #      print "current directory:$dirName";
          }
            $archcnt = $archcnt + 1;
          $filename = $file;
          $filename =~ s#.*$fileseparator##; # remove part before last slash 
          $dispfile = $filename;
          $filename = $filename.$dotc.$localtstamp;
          $jarArg = $jarArg.$dispfile." "; 
  
 } # end of age check
} #end of for
if ($archcnt > 0)
{
}
else
{
        print "\nNo trace files found matching the archival criteria!So nothing archived!";
        exit 0;

}

#stream the jar content
#open STDOUT
open(FILEHANDLE,'>-');
binmode FILEHANDLE;
my $BUFSIZE=32768;
#my $content = `$jarCmd -cM $jarArg`;
open JAR,"$jarCmd -cM $jarArg |" or die "cant fork:$!";
binmode JAR;
my $data;
my $bytes;
while (($bytes = read(JAR,$data,$BUFSIZE)) > 0)
{
  print FILEHANDLE $data;
}
if ($bytes eq undef)
{
 die "Error reading JAR stream";
}
close JAR or die "Error while archiving file!";
close FILEHANDLE;


foreach $file (@files) {
   if (-M $file >= $archiveAge)
   {
      if ($purgeflag eq $trueflag)
      {
           unlink $file;
           if (-e $file)
           {
              print "\nError purging trace file $file. Purge operation failed!";
              exit 1;
           }
      }
 } # end of age check
} #end of for

#if ($archcnt > 0)
#{

#   if ($purgeflag eq $trueflag)
#   {
#        print "\nArchiving and Purging of Trace files have been successfully completed.";
#   }
#   else
#   {
#        print "\nArchiving of Trace files have been successfully completed.";
#   }
#}
#else
#{
#        print "\nNo trace files found matching the archival criteria!So nothing archived!";
#}
