#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/createJarStream_v2.pl /st_emgc_pt-12.1.0.4pg/1 2012/08/01 23:53:25 shynaray Exp $
#
# createJarStream_v2.pl
# 
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      createJarStream_v2.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hasriniv    12/06/08 - Creation
# 
# 
use strict;
require "emd_common.pl";

my $jarCmd = shift(@ARGV);
my $metaFile=shift(@ARGV);

my $isWindows=0;
my $os= `ver`;
if($os =~ "Microsoft")
{
  $isWindows = 1; 
}

my $fileSep = "/";
if ($isWindows eq 1)
{
         $fileSep="\\";
}
open(METAFILE, "< $metaFile" ) or die "Can't open $metaFile : $!";
EMD_PERL_DEBUG ("createJarStream_v2: The metafile is $metaFile");
my @metadataarray = ();
while(my $content = <METAFILE> )
{
   chomp($content);
   push(@metadataarray,$content);
}
close(METAFILE);
#process meta data in order
my $numofDestFiles = @metadataarray;
my $jarArg;
my $fname;
for (my $idx=0;$idx <= $numofDestFiles-1; $idx++)
{
    # this array represents sourcefile, dest file and type
    my @metadata=split(";",$metadataarray[$idx]);
    if ($metadata[2] eq 'DIR')
    {
        $fname = $metadata[0];
        my $position = rindex($fname,$fileSep)+1;
        my $dirName = substr($fname,0,$position-1);
        my $fileName = substr($fname,$position);
        $jarArg = $jarArg." -C ".$dirName." $fileName";
    }
    else
    {
      $fname = $metadata[0];
      my $position = rindex($fname,$fileSep)+1;
      my $dirName = substr($fname,0,$position-1);
      my $fileName = substr($fname,$position);
      $jarArg = $jarArg." -C ".$dirName." $fileName";
    }
}#end of for loop
#open STDOUT
open(FILEHANDLE,'>-');
binmode FILEHANDLE;
my $BUFSIZE=32768;

my $mposition = rindex($metaFile,$fileSep)+1;
my $mdirName = substr($metaFile,0,$mposition-1);
my $mfileName = substr($metaFile,$mposition);
$jarArg = $jarArg." -C ".$mdirName." $mfileName";

EMD_PERL_DEBUG ("createJarStream_v2: The jar command is $jarCmd -cM $jarArg");
open JAR,"$jarCmd -cM $jarArg |" or die "cant fork:$!";
binmode JAR;
my $data;
my $bytes;
while (($bytes = read(JAR,$data,$BUFSIZE)) > 0)
{
  print FILEHANDLE $data;
}
if ($bytes eq undef)
{
 die "Error reading JAR stream";
}
close JAR or die "Error while grouping file!";
close FILEHANDLE;

EMD_PERL_DEBUG("createJarStream_v2: Jar stream creation complete");
#cleanup temp file created.
#unlink($metaFile);
