#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/cfVersionMisMatchStatus.pl /main/1 2011/04/21 11:06:49 glavash Exp $
#
# cfVersionMisMatchStatus.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#    cfVersionMisMatchStatus.pl - prints status of mismatched version in db .ll 
#
#    DESCRIPTION
#      Prints what commands needs to be run to correct the version mismatch. 
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    glavash     03/28/11 - ocm file
#    pparida     10/17/07 - XbranchMerge pparida_bug-6492554 from
#                           st_emll_10.2.7
#    pparida     10/15/07 - Fix bug 6492554: Use CCR_CONFIG_HOME for OCM log,
#                           state and config dirs.
#    dkapoor     01/23/07 - use print instead of warn
#    dkapoor     03/28/06 - use Oracle Configuration Manager instead of CCR 
#    dkapoor     12/05/05 - Creation
# 


use File::Spec;

require "$ENV{EMDROOT}/sysman/admin/scripts/semd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/db/net/listenerUtil.pl";


strict;

#Prints a warning for the version mis-match, if any found.
sub dbCFStatus
{
  my ($emdRoot,$hostName) = @_;
  my $ccrConfigHome = $ENV{CCR_CONFIG_HOME};
  my $configDir = File::Spec->catdir($ccrConfigHome,"state");
  my $DIR;
  opendir(DIR,$configDir);
  my @files = grep {/\.ll$/ }  readdir(DIR);
  my $num_files = @files;
  if ($num_files = 0 )
  {
	#there are no .ll files, return
	return ;
  }

  #Get the installed sql versions
  my $dbSQLVersion = getInstalledDBPL_SQLVersion();
  my $ebsDBSQLVersion = getInstalledEBSDBPL_SQLVersion();
  
  #List of db_names to the local SID mapping obtained from the .ll files 
  #in the state dir
  my %dbNameSIDs; # DB Name - > SID

  #List of mis-matched DB SQL version db_names to SID 
  #mapping from the .ll files in the state dir
  my %mismatchedVersionDBNames; # DB Name - > SID

  #List of mis-matched EBS DB SQL version db_names to SID 
  #mapping from the .ll files in the state dir
  #SID is picked from  dbNameSIDs, if found otherwise its "-"
  my %mismatchedVersionEBSDBNames; 

  foreach my $file (@files)
  {	
	my $fullFilePath = File::Spec->catdir($configDir,$file);
	EMD_PERL_DEBUG("$LOG_CATEGORY Days past since last modification on $fullFilePath=". (-M $fullFilePath));
	if( -M $fullFilePath >= 30)
	{
		#skip files more than 30 days old
		next;
	}
        EMD_PERL_DEBUG("$LOG_CATEGORY Handle $file");
	if ( $file =~ /(.*).ll$/)
        {
	    my $dbname = $1;
            if( $dbname =~ /(.*)-apps_(.*)$/ )
            {
		#Apps DB or cm file
		my ($errMsg, $collected_version) = 
			getConfigProperty($fullFilePath, "META_VER");
		if ($errMsg2 eq "" 
			&& trim($collected_version) ne trim($ebsDBSQLVersion)) 
		{
			if ( $dbNameSIDs{$1} eq "")
			{
				$mismatchedVersionEBSDBNames{$1} = "-";
			}
			else
			{
				$mismatchedVersionEBSDBNames{$1} = $dbNameSIDs{$1};
			}
			EMD_PERL_DEBUG("$LOG_CATEGORY Add EBS dB Name=$1 for SID=[$mismatchedVersionEBSDBNames{$1}]");
		}
            }
	    else
	    {
		#DB file
		my %sidTable = getSidsFromDBll($fullFilePath);
		my $sid;
		for $sid (keys %sidTable)
		{
			EMD_PERL_DEBUG("$LOG_CATEGORY SID= $sid for configfile=$fullFilePath");
         		if (&equalHosts($sidTable{$sid}, $hostName))
			{
				$dbNameSIDs{$dbname} = $sid;
				EMD_PERL_DEBUG("$LOG_CATEGORY Local SID");
				my ($errMsg, $collected_version) = 
					getConfigProperty($fullFilePath, "META_VER");
				if ($errMsg2 eq "" 
					&& trim($collected_version) ne trim($dbSQLVersion)) 
				{
					$mismatchedVersionDBNames{$dbname} = $sid;
				}
				last;
			}
            	}
            }
        }
  } 
  closedir (DIR);

  my $sidDisplayFormat = "     %-40.40s%-35.35s\n";
  my $length = (keys %mismatchedVersionDBNames);
  my $ebs_length = (keys %mismatchedVersionEBSDBNames);
  if ($length > 0 || $ebs_length > 0)
  {
	print "\nWARN: Oracle Configuration Manager database objects are not in sync with 
the installed configuration collection scripts.\n";
        print "Refer to the Installation and Configuration documentation on reloading the 
SQL collection packages.\n";
	printf ($sidDisplayFormat,"SID","Script");
	printf ($sidDisplayFormat,"----","-----");
  }
  foreach $dbName (keys %mismatchedVersionDBNames)
  {
	printf ($sidDisplayFormat,$mismatchedVersionDBNames{$dbName},"collectconfig");
  }

  my $sid;
  foreach $dbName (keys %mismatchedVersionEBSDBNames)
  {
	if( $dbNameSIDs{$dbName} ne "")
	{
		$sid = $dbNameSIDs{$dbName};
	}
	else
	{
		#default sid for unknown db name
		$sid = "<SID for DBNAME=\"$dbName\">";
	}
	printf ($sidDisplayFormat,$sid,"ebs_collectconfig");
  } 
}
