# 
# $Header: emdb/sysman/admin/scripts/db/config/dbconfigure.pl /main/6 2010/07/18 00:53:21 prapatil Exp $
#
# dbconfigure.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbconfigure.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mreddych    04/02/09 - TO forward-merge bug#8342831
#    ngade       07/20/05 - remove bin perl
#    ngade       06/06/05 - ngade_dbconfig0606
#    ngade       05/20/05 - Creation
# 
use strict;
require "emd_common.pl";
require "db/db_common.pl";

## global variables.
use vars qw($oracle_home $oracle_sid $operation $db_user $db_password $db_role $dbm_password $basic_install $perfstat_password $default_tablespace $temp_tablespace);

use vars qw($sqlcmd $connect_string);

## constants
use constant OPERATION_CONFIG         => 'CONFIG';
use constant OPERATION_UNCONFIG       => 'UNCONFIG';
use constant DEFAULT_VALUE            => 'DEF';
use constant CONFIG_SQL_DIR           => 'scripts/db/config/';
use constant CONFIG_SQLFILE           => 'dbconfig.sql';
use constant UNCONFIG_SQLFILE         => 'dbunconfig.sql';


###################################################
## Main calls
###################################################
sub do_configure
{
  if($operation eq OPERATION_CONFIG)
  {
    &set_default_values();
  }
  $connect_string = &get_connect_string;
  &generate_cmd;
  &executeSQLPlus;
}

sub set_default_values
{
  if(!defined($basic_install) || $basic_install =~ /TRUE/i)
  {
    $basic_install = DEFAULT_VALUE;
    $perfstat_password = DEFAULT_VALUE; 
    $default_tablespace = DEFAULT_VALUE; 
    $temp_tablespace = DEFAULT_VALUE; 
  }
  else
  {
    $basic_install = "N";
  }
}

sub executeSQLPlus
{
  &set_env_var($oracle_home, $oracle_sid, "FALSE");

  my $SQLPID = open(SQL, "|$ENV{ORACLE_HOME}/bin/sqlplus /nolog");
 if(!$SQLPID)
  {
    print_error("ERROR: could not run SQLPLUS\n");
    exit (1);
  }
  print_debug("SQLPID = $SQLPID");
  print SQL "\@$sqlcmd\n";
  print SQL "exit\n";
  close(SQL);
}

sub get_connect_string
{
  if($db_role =~ /SYSDBA/i)
  {
    return "\"$db_user/$db_password as $db_role\"";
  }
  else
  {
    return "\"$db_user/$db_password\"";
  }
}


sub generate_cmd
{
  if($operation eq OPERATION_CONFIG)
  {
    $sqlcmd = $ENV{PLUGIN_ROOT}."/".CONFIG_SQL_DIR.CONFIG_SQLFILE;
    $sqlcmd = $sqlcmd." $connect_string $basic_install $dbm_password $perfstat_password $default_tablespace $temp_tablespace";
  }
  else
  {
    $sqlcmd = $ENV{PLUGIN_ROOT}."/".CONFIG_SQL_DIR.UNCONFIG_SQLFILE;
    $sqlcmd = $sqlcmd." $connect_string";
  }
}

sub print_error
{
  print STDOUT @_;
  EMD_PERL_ERROR(@_);
}

sub print_debug
{  
  if(EMAGENT_isPerlDebugEnabled())
  {
     EMD_PERL_DEBUG("DBCONFIGURE: ".@_);
  }
  ## For perl testing Uncomment this line
  ## print STDOUT @_;
}
