#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/configVersion.pl /main/1 2011/04/21 11:06:49 glavash Exp $
#
# configVersion.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      configVersion.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    glavash     03/28/11 - ocm file
#    jsutton     02/25/11 - fix empty string check
#    dkapoor     01/16/07 - don't exit with error
#    dkapoor     12/02/05 - use ccr/ccr_common 
#    dkapoor     10/05/05 - dkapoor_bug-4558701
#    dkapoor     10/05/05 - read installed version from 
#                           admin/scripts/db_ll_pkgdefs.sql 
#    dkapoor     10/05/05 - Creation
# 
strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

use File::Spec;
use File::Basename;

my ($configFile) = @ARGV;


EMD_PERL_INFO("In configMetricCollector for  configfile=[$configFile]");

if (!defined $configFile )
{
    EMD_PERL_INFO("em_error=The livelink configuration file not passed.");
    print STDERR "em_error=The livelink configuration file not passed.\n";
    exit;
}
if( !(-f $configFile))
{
    print STDERR "em_error=The livelink configuration file \"$configFile\" not found.\n";
    exit;
}

my ($errMsg,$installed_version) = getInstalledDBPL_SQLVersion($configFile);
if ($errMsg ne "")
{
  EMD_PERL_DEBUG("em_error=$errMsg");
  print STDERR "em_error=$errMsg";
}

if(!defined $installed_version || $installed_version eq "")
{
  $installed_version = 'NULL';
}

my ($err,$collected_version) = getConfigProperty($configFile,"META_VER");

if ($err ne "")
{
  EMD_PERL_DEBUG("em_error=$err");
  print STDERR "em_error=$err";
}

if(!defined $collected_version || $collected_version eq "")
{
  $collected_version = 'NULL';
}

$installed_version = trim($installed_version);
$collected_version = trim($collected_version);
print "em_result=$installed_version|$collected_version\n";

