# $Header: emdb/sysman/admin/scripts/db/dataUtilities/importUnpack.pl /main/4 2010/07/18 00:53:21 prapatil Exp $
#
# importUnpack.pl
#
# Copyright (c) 2007, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      importUnpack.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mvajapey    06/04/08 - 
#    abilagi     06/04/08 - 
#    mvajapey    05/29/08 - 
#    ezeng       07/23/07 - Creation
#
require "db/dbstate.pl";
require "db/db_common.pl";
require "emd_common.pl";

use strict;

## global variables.
use vars qw($oracle_home $oracle_sid $tns_connect @SQLCMDS $DBROLE_NORMAL);

sub stsImportUnpack()
{
    my($user, $password, $role, $job_name, $dirobject) = @_;

    &set_env_var($oracle_home, $oracle_sid, 1);

    my $sql = "declare h1 NUMBER; job_state VARCHAR2(30); sts ku\$_Status; status ku\$_Status; stgTabName varchar2(200); stgTabOwner varchar2(200);\n";
    $sql .= "begin h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'TABLE', job_name => 'M_IMP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'TRACE', value => 16712448);\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 1);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'IMPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'MASTER_ONLY', value => 1);\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "LOOP dbms_datapump.get_status(handle => h1, mask => 13, timeout => -1, job_state => job_state, status => status); EXIT WHEN status.job_status.state = 'COMPLETED'; end LOOP;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "dbms_datapump.create_job_view(job_schema => '$user', job_name => 'M_IMP_$job_name', view_name => 'VM_IMP_$job_name');\n";
    $sql .= "execute immediate 'SELECT t.object_schema, t.object_long_name FROM (SELECT object_schema, object_long_name FROM VM_IMP_$job_name WHERE (object_type = ''TABLE'')) t WHERE rownum = 1 ' into stgTabOwner, stgTabName;\n";
    $sql .= "execute immediate 'drop table M_IMP_$job_name ';\n";
    $sql .= "execute immediate 'drop view VM_IMP_$job_name ';\n";
    $sql .= "h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'FULL', job_name => 'IMP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 0);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'IMPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'REUSE_DATAFILES', value => 0);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'SKIP_UNUSABLE_INDEXES', value => 0);\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "job_state := 'UNDEFINED'; while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop DBMS_DATAPUMP.get_status(h1, DBMS_DATAPUMP.ku\$_status_job_error + DBMS_DATAPUMP.ku\$_status_job_status + DBMS_DATAPUMP.ku\$_status_wip,-1,job_state,sts); dbms_lock.sleep(1); end loop;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "dbms_sqltune.unpack_stgtab_sqlset(sqlset_name => '%', sqlset_owner => '%', replace => true, staging_table_name => stgTabName, staging_schema_owner => stgTabOwner);\n";
    $sql .= "execute immediate 'drop table ' || stgTabOwner || '.' || stgTabName ;\n";
    $sql .= "end;\n";
    $sql .= "/\n";
    @SQLCMDS = $sql;
    execute_sqlplus($user, $password, $role);
}

sub spImportUnpack()
{
    my($user, $password, $role, $job_name, $dirobject) = @_;

    &set_env_var($oracle_home, $oracle_sid, 1);

    my $sql = "declare h1 NUMBER; job_state VARCHAR2(30); sts ku\$_Status; status ku\$_Status; stgTabName varchar2(200); stgTabOwner varchar2(200);\n";
    $sql .= "begin h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'TABLE', job_name => 'M_IMP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'TRACE', value => 16712448);\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 1);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'IMPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'MASTER_ONLY', value => 1);\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "LOOP dbms_datapump.get_status(handle => h1, mask => 13, timeout => -1, job_state => job_state, status => status); EXIT WHEN status.job_status.state = 'COMPLETED'; end LOOP;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "dbms_datapump.create_job_view(job_schema => '$user', job_name => 'M_IMP_$job_name', view_name => 'VM_IMP_$job_name');\n";
    $sql .= "execute immediate 'SELECT t.object_schema, t.object_long_name FROM (SELECT object_schema, object_long_name FROM VM_IMP_$job_name WHERE (object_type = ''TABLE'')) t WHERE rownum = 1 ' into stgTabOwner, stgTabName;\n";
    $sql .= "execute immediate 'drop table M_IMP_$job_name ';\n";
    $sql .= "execute immediate 'drop view VM_IMP_$job_name ';\n";
    $sql .= "h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'FULL', job_name => 'IMP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 0);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'IMPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'REUSE_DATAFILES', value => 0);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'SKIP_UNUSABLE_INDEXES', value => 0);\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "job_state := 'UNDEFINED'; while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop DBMS_DATAPUMP.get_status(h1, DBMS_DATAPUMP.ku\$_status_job_error + DBMS_DATAPUMP.ku\$_status_job_status + DBMS_DATAPUMP.ku\$_status_wip,-1,job_state,sts); dbms_lock.sleep(1); end loop;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "dbms_sqltune.unpack_stgtab_sqlprof(profile_category => '%', replace => true, staging_table_name => stgTabName, staging_schema_owner => stgTabOwner);\n";
    $sql .= "execute immediate 'drop table ' || stgTabOwner || '.' || stgTabName ;\n";
    $sql .= "end;\n";
    $sql .= "/\n";
    @SQLCMDS = $sql;
    execute_sqlplus($user, $password, $role);
}

sub spbImportUnpack()
{
    my($user, $password, $role, $job_name, $dirobject) = @_;

    &set_env_var($oracle_home, $oracle_sid, 1);

    my $sql = "declare cnt NUMBER; h1 NUMBER; job_state VARCHAR2(30); sts ku\$_Status; status ku\$_Status; stgTabName varchar2(200); stgTabOwner varchar2(200);\n";
    $sql .= "begin h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'TABLE', job_name => 'M_IMP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'TRACE', value => 16712448);\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 1);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'IMPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'MASTER_ONLY', value => 1);\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "LOOP dbms_datapump.get_status(handle => h1, mask => 13, timeout => -1, job_state => job_state, status => status); EXIT WHEN status.job_status.state = 'COMPLETED'; end LOOP;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "dbms_datapump.create_job_view(job_schema => '$user', job_name => 'M_IMP_$job_name', view_name => 'VM_IMP_$job_name');\n";
    $sql .= "execute immediate 'SELECT t.object_schema, t.object_long_name FROM (SELECT object_schema, object_long_name FROM VM_IMP_$job_name WHERE (object_type = ''TABLE'')) t WHERE rownum = 1 ' into stgTabOwner, stgTabName;\n";
    $sql .= "execute immediate 'drop table M_IMP_$job_name ';\n";
    $sql .= "execute immediate 'drop view VM_IMP_$job_name ';\n";
    $sql .= "h1 := dbms_datapump.open (operation => 'IMPORT', job_mode => 'FULL', job_name => 'IMP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 0);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'IMPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'REUSE_DATAFILES', value => 0);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'SKIP_UNUSABLE_INDEXES', value => 0);\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "job_state := 'UNDEFINED'; while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop DBMS_DATAPUMP.get_status(h1, DBMS_DATAPUMP.ku\$_status_job_error + DBMS_DATAPUMP.ku\$_status_job_status + DBMS_DATAPUMP.ku\$_status_wip,-1,job_state,sts); dbms_lock.sleep(1); end loop;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "cnt := dbms_spm.unpack_stgtab_baseline(table_name => stgTabName, table_owner => stgTabOwner);\n";
    $sql .= "execute immediate 'drop table ' || stgTabOwner || '.' || stgTabName ;\n";
    $sql .= "end;\n";
    $sql .= "/\n";
    @SQLCMDS = $sql;
    execute_sqlplus($user, $password, $role);
}

sub execute_sqlplus
{
    my ($dbUsername, $dbPassword, $dbRole) = @_;
    my $connStr;

    if (defined($tns_connect) && $tns_connect ne "")
    {
        $connStr = "${dbUsername}/${dbPassword}\@${tns_connect}";
    }
    else
    {
        $connStr = "${dbUsername}/${dbPassword}";
    }
    if (!($dbRole =~ /$DBROLE_NORMAL/i || $dbRole eq ''))
    {
        $connStr .= " as $dbRole";
    }

    return (&executeSQLPlus($connStr));
}

1;
