# $Header: emdb/sysman/admin/scripts/db/dataUtilities/load.pl /st_emgc_pt-12.1.0.4pg/2 2012/09/11 02:37:33 anstephe Exp $
#
# load.pl
#
# Copyright (c) 2002, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      load.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    anstephe    09/10/12 - Adding connect string to userid
#    anstephe    06/06/12 - Adding support for PDB Database
#    rgiroux     01/28/05 - fix for bug 4094619; REALLY delete control and 
#                           data files 
#    rgiroux     09/17/04 - fix for bug 3875553; display ORA errors to the 
#                           user 
#    rgiroux     07/02/04 - inplement delete of control and data file after 
#                           use 
#    ngade       04/01/04 - tts support and cleanup
#    ngade       09/19/03 - nt fix -bug 3134969 
#    npamnani    09/18/03 - fix for bug 3134969 
#    ngade       02/21/03 - remove using perl from /usr/local/bin
#    ngade       01/17/03 - add support for db_10_or_higher
#    ngade       11/21/02 - remove 10i version check
#    ngade       10/23/02 - remove checking for fileExecute permissions
#    ngade       09/23/02 - change support for lower-case users/tables
#    ngade       09/04/02 - 
#    ngade       08/29/02 - fix bug 2463124
#    ngade       08/08/02 - cleanup tempfiles
#    rgiroux     08/02/02 - rgiroux_start_10i_support
#    rgiroux     08/02/02 - Creation
#    ngade       07/19/02 - show log output
#    ngade       06/26/02 - ngade_change_job_submission
#    ngade       06/26/02 - Creation
#

require "db/db_common.pl";
require "db/dataUtilities/datapump_job.pl";

use strict;

## global variables.
use vars qw($oracle_home $tns_connect $oracle_sid $parse_errors $script $generate_log $log_file_name $smp_ignore $delete_control_file $delete_data_file);

###################################################
##   MAIN SCRIPT TO CALL EXPORT JOB.
###################################################
sub load()
{
  print_debug("Load Started..........\n");
  my ($user, $password, $role, $db_10_or_higher) = @_;

  if(!defined($db_10_or_higher))
  {
    $db_10_or_higher = "FALSE";
  }
  
  &set_env_var($oracle_home, $oracle_sid, $db_10_or_higher);
  my $log_file = run_load(&set_userid($user, $password, $role));

  if($parse_errors =~ /TRUE/i)
  {
    parse_log($log_file);
  }
  if(defined($delete_control_file))
  {
    removeFile($delete_control_file); 
  }
  if(defined($delete_data_file))
  {
    removeFile($delete_data_file); 
  }
}

###################################################
##  SET DATABASE USERID
###################################################
sub set_userid()
{
  my($user, $password, $role) = @_;
  my $userid = $user."/".$password;
  if ($tns_connect && $tns_connect ne "")
  {
         $userid = $userid . "@". $tns_connect;
  }

  $userid = ($role =~ /NORMAL/i)? $userid: "$userid as $role";
  return $userid;
}

###################################################
##  PERFORM LOAD OPERATION.
###################################################
sub run_load
{
  print_debug("Data Pump Load: Running Load....\n");

  my($userid) = @_;

  # Create a temporary File
  (my $param_fh, my $param_filename) = create_temp_file();
  
  open(PARAM_FILE, ">$param_filename");
  print PARAM_FILE $script;
  close PARAM_FILE; 

  my $load_exe = "$ENV{ORACLE_HOME}/bin/sqlldr";
  my $command = "|$load_exe PARFILE='$param_filename'";

  if($generate_log =~ /FALSE/i)
  {
    my($log_fh, $log_file) = create_temp_file(".log");
    close $log_fh;
    $command = $command." "."LOG=$log_file";
    $log_file_name = $log_file;
  }

  print_debug("Load: Command: $command\n");
  print_debug("Load: generate_log:  $generate_log\n");
  print_debug("Load: log_file_name: $log_file_name\n");

  open(DATA_MGMT, $command)|| die "Couldn't execute $load_exe";
  print DATA_MGMT "$userid\n"; 
  print DATA_MGMT "exit";
  close DATA_MGMT;

  close $param_fh;
  return $log_file_name;
}

###################################################
##  PARSE LOG FILE FOR ERRORS.
###################################################
sub parse_log()
{
  print_debug("Data Pump Load: Parsing logfile: $_[0]\n");

  if (-e $_[0])
  {
    open(LOGFILE, $_[0]) || die "Can't open :$!\n";
    my @cont_arr = <LOGFILE>;
    close LOGFILE;
    my $cont = "@cont_arr";
  
    if(($cont !~ /ORA-[0-9]/) && ($cont !~ /SQL\*Loader-[0-9]/))
    {
      print_debug("Data Pump Load: No Errors\n");
    }
    else
    {
      ## If sqlldr fails with ORA-errors, output is written to log file but not STDOUT.
      ## Hence capture the contents of the logfile and write to STDOUT.
      if($cont =~ /ORA-[0-9]/)
      {
        print STDOUT $cont;
      }
      if($cont =~ /SQL\*Loader-[0-9]/)
      {
        print_debug("Data Pump Load: LOADER ERROR[0-9]\n");
        exit(1);
      }
      elsif($smp_ignore eq "true")
      {
        print_debug("Data Pump Load: SMP_IGNORE=TRUE\n");
      }
      else
      {
        print_debug("Data Pump Load:SMP_IGNORE = $smp_ignore\n");
        exit(1);
      }
    }
  }
  else
  {
     print_error("Data Pump Load: File does not exist: $_[0]\n");
  }
}

###################################################
##  TEST CASE FOR LOAD.
## 1. Uncomment loadtest(), modify any parameters.
## 2. set EMDROOT and run command
## 3. runperl load.pl
###################################################
##&loadtest();
sub loadtest()
{
  $oracle_home = $ENV{ORACLE_HOME};
  $oracle_sid = $ENV{ORACLE_SID};
  $script = " control=$ENV{ORACLE_HOME}/rdbms/demo/ulcase1.ctl log=/tmp/load.log";
  $smp_ignore="true";
  $generate_log="true";
  $parse_errors="true";
  $log_file_name="/tmp/load.log";
  
  my $db_user="SYSMAN";
  my $db_passwd="sysman";
  my $db_role="normal";
  
  &load($db_user, $db_passwd, $db_role);  
}
1;
