# $Header: emdb/sysman/admin/scripts/db/dataUtilities/packExport.pl /main/5 2012/01/11 16:35:03 gan Exp $
#
# packExport.pl
#
# Copyright (c) 2007, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      packExport.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    mvajapey    06/04/08 - 
#    abilagi     06/04/08 - 
#    mvajapey    05/29/08 - 
#    ezeng       07/23/07 - Creation
#
require "db/dbstate.pl";
require "db/db_common.pl";
require "emd_common.pl";

use strict;


## global variables.
use vars qw($oracle_home $oracle_sid $tns_connect @SQLCMDS $DBROLE_NORMAL);

sub stsPackExport()
{
    my($user, $password, $role, $job_name, $sqlset, $owner, $dirobject) = @_;
    EMD_PERL_DEBUG("packExport.stsPackExport: parameters are: ");
    EMD_PERL_DEBUG("packExport.stsPackExport: user ".$user);
    EMD_PERL_DEBUG("packExport.stsPackExport: job_name ".$job_name);
    EMD_PERL_DEBUG("packExport.stsPackExport: sqlset ".$sqlset);
    EMD_PERL_DEBUG("packExport.stsPackExport: owner ".$owner);
    EMD_PERL_DEBUG("packExport.stsPackExport: diretory ".$dirobject);
    EMD_PERL_DEBUG("packExport.stsPackExport: oracle home ".$oracle_home);
    EMD_PERL_DEBUG("packExport.stsPackExport: oracle sid ".$oracle_sid);

    &set_env_var($oracle_home, $oracle_sid, 1);


    my $sql = "declare h1 NUMBER; job_state VARCHAR2(30); sts ku\$_Status; status ku\$_Status; stgTabName varchar2(200); stgTabOwner varchar2(200);\n";
    $sql .= "begin\n";
    $sql .= "dbms_sqltune.create_stgtab_sqlset(table_name => '$job_name', schema_name=> '$user');\n";
    $sql .= "dbms_sqltune.pack_stgtab_sqlset(sqlset_name => '$sqlset', sqlset_owner => '$owner', staging_table_name => '$job_name', staging_schema_owner => '$user');\n";
    $sql .= "h1 := dbms_datapump.open (operation => 'EXPORT', job_mode => 'TABLE', job_name => 'EXP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'EXPDAT_$job_name.LOG', directory => '$dirobject', filetype => 3);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 0);\n";
    $sql .= "dbms_datapump.metadata_filter(handle => h1, name => 'SCHEMA_EXPR', value => 'IN(''$user'')');\n";
    $sql .= "dbms_datapump.metadata_filter(handle => h1, name => 'NAME_EXPR', value => 'IN(''$job_name'')');\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'EXPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'ESTIMATE', value => 'BLOCKS');\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "job_state := 'UNDEFINED'; while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop DBMS_DATAPUMP.get_status(h1, DBMS_DATAPUMP.ku\$_status_job_error + DBMS_DATAPUMP.ku\$_status_job_status + DBMS_DATAPUMP.ku\$_status_wip,-1,job_state,sts); dbms_lock.sleep(1); end loop;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "execute immediate 'drop table $user.$job_name';\n";
    $sql .= "end;\n";
    $sql .= "/\n";
    EMD_PERL_DEBUG("packExport.stsPackExport: SQL ".$sql);
    @SQLCMDS = $sql;
    my $SQLPLUS_RET_CODE = execute_sqlplus($user, $password, $role);
    EMD_PERL_DEBUG("packExport.stsPackExport: SQLPLUS returns ".$SQLPLUS_RET_CODE);
    return $SQLPLUS_RET_CODE;
}

sub spPackExport()
{
    my($user, $password, $role, $job_name, $ref_profiles, $ref_categories, $dirobject) = @_;
    my @profiles = @{$ref_profiles};
    my @categories = @{$ref_categories};
    my $proflen = scalar(@profiles);

    &set_env_var($oracle_home, $oracle_sid, 1);

    my $count;
    my $cur_profile;
    my $cur_category;

    my $sql = "declare h1 NUMBER; job_state VARCHAR2(30); sts ku\$_Status; status ku\$_Status; stgTabName varchar2(200); stgTabOwner varchar2(200);\n";
    $sql .= "begin\n";
    $sql .= "dbms_sqltune.create_stgtab_sqlprof(table_name => '$job_name', schema_name=> '$user');\n";

    for ($count = 0; $count < $proflen; $count++)
    {
      $cur_profile = $profiles[$count];
      $cur_category = $categories[$count];
      $sql .= "dbms_sqltune.pack_stgtab_sqlprof(staging_table_name => '$job_name', staging_schema_owner => '$user', profile_name => '$cur_profile', profile_category => '$cur_category');\n";
    }

    $sql .= "h1 := dbms_datapump.open (operation => 'EXPORT', job_mode => 'TABLE', job_name => 'EXP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'EXPDAT_$job_name.LOG', directory => '$dirobject', filetype => 3);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 0);\n";
    $sql .= "dbms_datapump.metadata_filter(handle => h1, name => 'SCHEMA_EXPR', value => 'IN(''$user'')');\n";
    $sql .= "dbms_datapump.metadata_filter(handle => h1, name => 'NAME_EXPR', value => 'IN(''$job_name'')');\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'EXPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'ESTIMATE', value => 'BLOCKS');\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "job_state := 'UNDEFINED'; while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop DBMS_DATAPUMP.get_status(h1, DBMS_DATAPUMP.ku\$_status_job_error + DBMS_DATAPUMP.ku\$_status_job_status + DBMS_DATAPUMP.ku\$_status_wip,-1,job_state,sts); dbms_lock.sleep(1); end loop;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "execute immediate 'drop table $user.$job_name';\n";
    $sql .= "end;\n";
    $sql .= "/\n";
    @SQLCMDS = $sql;
    execute_sqlplus($user, $password, $role);
}

sub spbPackExport()
{
    my($user, $password, $role, $job_name, $ref_sqls, $ref_baselines, $dirobject) = @_;
    my @sqls = @{$ref_sqls};
    my @baselines = @{$ref_baselines};
    my $plnlen = scalar(@sqls);

    &set_env_var($oracle_home, $oracle_sid, 1);

    my $count;
    my $cur_sql;
    my $cur_baseline;

    my $sql = "declare cnt number; h1 NUMBER; job_state VARCHAR2(30); sts ku\$_Status; status ku\$_Status; stgTabName varchar2(200); stgTabOwner varchar2(200);\n";
    $sql .= "begin\n";
    $sql .= "dbms_spm.create_stgtab_baseline(table_name => '$job_name', table_owner=> '$user');\n";

    for ($count = 0; $count < $plnlen; $count++)
    {
      $cur_sql = $sqls[$count];
      $cur_baseline = $baselines[$count];
      $sql .= "cnt := dbms_spm.pack_stgtab_baseline(table_name => '$job_name', table_owner => '$user', sql_handle => '$cur_sql', plan_name => '$cur_baseline');\n";
    }

    $sql .= "h1 := dbms_datapump.open (operation => 'EXPORT', job_mode => 'TABLE', job_name => 'EXP_$job_name', version => 'COMPATIBLE');\n";
    $sql .= "dbms_datapump.set_parallel(handle => h1, degree => 1);\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'EXPDAT_$job_name.LOG', directory => '$dirobject', filetype => 3);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'KEEP_MASTER', value => 0);\n";
    $sql .= "dbms_datapump.metadata_filter(handle => h1, name => 'SCHEMA_EXPR', value => 'IN(''$user'')');\n";
    $sql .= "dbms_datapump.metadata_filter(handle => h1, name => 'NAME_EXPR', value => 'IN(''$job_name'')');\n";
    $sql .= "dbms_datapump.add_file(handle => h1, filename => 'EXPDAT_$job_name.DMP', directory => '$dirobject', filetype => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'INCLUDE_METADATA', value => 1);\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'DATA_ACCESS_METHOD', value => 'AUTOMATIC');\n";
    $sql .= "dbms_datapump.set_parameter(handle => h1, name => 'ESTIMATE', value => 'BLOCKS');\n";
    $sql .= "dbms_datapump.start_job(handle => h1, skip_current => 0, abort_step => 0);\n";
    $sql .= "job_state := 'UNDEFINED'; while (job_state != 'COMPLETED') and (job_state != 'STOPPED') loop DBMS_DATAPUMP.get_status(h1, DBMS_DATAPUMP.ku\$_status_job_error + DBMS_DATAPUMP.ku\$_status_job_status + DBMS_DATAPUMP.ku\$_status_wip,-1,job_state,sts); dbms_lock.sleep(1); end loop;\n";
    $sql .= "dbms_datapump.detach(handle => h1);\n";
    $sql .= "execute immediate 'drop table $user.$job_name';\n";
    $sql .= "end;\n";
    $sql .= "/\n";
    @SQLCMDS = $sql;
    execute_sqlplus($user, $password, $role);
}

sub execute_sqlplus
{
    my ($dbUsername, $dbPassword, $dbRole) = @_;
    my $connStr;

    if (defined($tns_connect) && $tns_connect ne "")
    {
        $connStr = "${dbUsername}/${dbPassword}\@${tns_connect}";
    }
    else
    {
        $connStr = "${dbUsername}/${dbPassword}";
    }
    if (!($dbRole =~ /$DBROLE_NORMAL/i || $dbRole eq ''))
    {
        $connStr .= " as $dbRole";
    }

    return (&executeSQLPlus($connStr));
}

1;
