#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/dbAuditPerm.pl /main/16 2012/01/03 10:24:56 hpalitan Exp $
#
# dbAuditPerm.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbAuditPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    12/28/11 - Only raise violation when Group or World has write
#                           access
#    hpalitan    02/17/11 - Use get_osType()
#    manosing    02/24/07 - adding check for 0( )
#    manosing    12/28/06 - flood control for windows policy
#    ssalunke    12/10/06 - Fixing bug 5697385 - DBAUDITPERM METRIC NOT
#                           COLLECTED ON SOLARIS
#    dsukhwal    05/04/05 - handle win32 cases 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/28/04 - Removed check_permission() 
#    dkjain      12/17/04 - Remove else part which gets executed for null path 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";

  my $dsn = "dbi:Oracle:" ;
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $OSNAME = get_osType();

  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

  my $property1 = "audit_file_dest" ;  #the properties are nt_$property for mswin32. This is effected in the subroutine 
                            #db_audit_perm by suffixing nt_
  my $property2 = "user_dump_dest" ;
  my $property3 = "background_dump_dest" ;
  my $property4 ="core_dump_dest";
  
  my $afdMax = $ENV{'AFDMAX'};
  my $uddMax = $ENV{'UDDMAX'};
  my $bddMax = $ENV{'BDDMAX'};
  my $cddMax = $ENV{'CDDMAX'};

 if (EMAGENT_isPerlDebugEnabled())
{
    EMD_PERL_DEBUG ("dbControlFilesPerm: OS         = $OSNAME");
    EMD_PERL_DEBUG ("dbControlFilesPerm: oracleHome = $oracleHome");
	EMD_PERL_DEBUG ("dbControlFilesPerm: property1  = $property1");
	EMD_PERL_DEBUG ("dbControlFilesPerm: property2  = $property2");
	EMD_PERL_DEBUG ("dbControlFilesPerm: property3  = $property3");
	EMD_PERL_DEBUG ("dbControlFilesPerm: property4  = $property4");
    EMD_PERL_DEBUG ("dbControlFilesPerm: username   = $username");
    EMD_PERL_DEBUG ("dbControlFilesPerm: address    = $address");
    EMD_PERL_DEBUG ("dbControlFilesPerm: role       = $role");
    EMD_PERL_DEBUG ("dbControlFilesPerm: afdMax     = $afdMax");
	EMD_PERL_DEBUG ("dbControlFilesPerm: uddMax     = $uddMax");
	EMD_PERL_DEBUG ("dbControlFilesPerm: bddMax     = $bddMax");
	EMD_PERL_DEBUG ("dbControlFilesPerm: cddMax     = $cddMax");
	EMD_PERL_DEBUG ("dbControlFilesPerm: mode       = $mode");
}
  
  my $table = "v\$parameter";  
  my $value = "value";
  my $name = "name"; 

  my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
  #verfied that this value will have no comma separated destinations
  #only one row per policy
  my @auditFileDest = getValue($dbh,$value,$name, "audit_file_dest",$table);
  my @userDumpDest = getValue($dbh,$value,$name, "user_dump_dest",$table);
  my @backgrdDumpDest = getValue($dbh,$value,$name, "background_dump_dest",$table);
  my @coreDumpDest = getValue($dbh,$value,$name, "core_dump_dest",$table);
  close_db_connection($dbh);

  if($auditFileDest[0] ne ""){
    db_audit_perm($property1,$auditFileDest[0], $afdMax); 
  }

  if($userDumpDest[0] ne ""){
   db_audit_perm($property2,$userDumpDest[0], $uddMax);
  }

  if($backgrdDumpDest[0] ne ""){
   db_audit_perm($property3,$backgrdDumpDest[0], $bddMax);
  }

  if($coreDumpDest[0] ne ""){
   db_audit_perm($property4,$coreDumpDest[0], $cddMax);
  }


 sub db_audit_perm{
    my $retMode;
    my $permString ;
    my ($property,$fpath,$maxRows) = @_ ;
    $fpath =~ s/^\?/$oracleHome/g;
    if($OSNAME ne "WIN"){#platform is not Windows 
        $retMode = file_perm($fpath);  
        if($retMode >= 0){ #file_perm returns -1 in case of failure
            $retMode = $retMode & 0777 ;
            if(($retMode & 0022)){
               $fpath = check_512char($fpath);   	
               printf "em_result=$property|%03o|$fpath\n", $retMode ;
            }
        }
    }
    elsif($OSNAME eq "WIN"){
        my $perm = win32_file_perm($fpath);
        if($perm != -1){
            print "em_result=nt_$property|$perm|$fpath\n";
        }
    }
 }

