#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/dbControlFilesPerm.pl /main/14 2012/01/03 10:24:56 hpalitan Exp $
#
# dbControlFilesPerm.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbControlFilesPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    12/28/11 - Only raise violation when Group or World has write
#                           access
#    hpalitan    02/17/11 - Use get_osType()
#    manosing    12/28/06 - flood control for windows policy
#    ssalunke    12/11/06 - Adding support for other unix operating systems
#    dsukhwal    05/20/05 - Adding support to limit the num of rwos to b 
#                           uploaded 
#    dkjain      12/26/04 - Comma separated string splits up 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";
  
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $maxCount;
  my $rowNum = 0;
  my $OSNAME = get_osType();

  if($OSNAME eq "WIN"){
    $maxCount = $ENV{NCMAXCOUNT} ;
  }else{
    $maxCount = $ENV{CMAXCOUNT} ;
  } 
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

 
 my $property = "db_control_files_perm" ;#the property  is nt_$property for mswin32.
 my $table = "v\$parameter";  
 my $value = "value";
 my $name = "name" ;
 my $dsn = "dbi:Oracle:";
 my $limit = 0;

 if (EMAGENT_isPerlDebugEnabled())
{
    EMD_PERL_DEBUG ("dbControlFilesPerm: OS         = $OSNAME");
    EMD_PERL_DEBUG ("dbControlFilesPerm: oracleHome = $oracleHome");
	EMD_PERL_DEBUG ("dbControlFilesPerm: property   = $property");
    EMD_PERL_DEBUG ("dbControlFilesPerm: username   = $username");
    EMD_PERL_DEBUG ("dbControlFilesPerm: address    = $address");
    EMD_PERL_DEBUG ("dbControlFilesPerm: role       = $role");
    EMD_PERL_DEBUG ("dbControlFilesPerm: maxCount   = $maxCount");
	EMD_PERL_DEBUG ("dbControlFilesPerm: mode       = $mode");
}

 my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
 my @controlFiles = getValue($dbh,$value,$name, "control_files",$table);
 close_db_connection($dbh);
 my $mask = 022 ;
 $globalProperty = $property ;  
 if($controlFiles[0] ne ""){
    if($OSNAME ne "WIN"){#platform is unix
        comma_separated_files($controlFiles[0],$mask,$maxCount);
    }
    elsif($OSNAME eq "WIN"){
        win32_comma_sep_files_perm($controlFiles[0], $maxCount, "nt_$property");
    }
 }

