#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/dbDataFilePerm.pl /main/16 2012/01/03 10:24:56 hpalitan Exp $
#
# dbDataFilePerm.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbDataFilePerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    12/28/11 - Only raise violation when Group or World has write
#                           access
#    hpalitan    02/17/11 - Use get_osType()
#    hpalitan    01/14/11 - Document Permission checks
#    manosing    12/28/06 - flood control for windows policy
#    manosing    12/21/06 - adding check for  "0()" 
#    ssalunke    12/11/06 - Adding support for other unix operating systems
#    dsukhwal    05/20/05 - limit the number of rows 
#    dsukhwal    05/04/05 - handle win32 cases 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/28/04 - Removed check_permission()
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";

  if (EMAGENT_isPerlDebugEnabled())
  {
    EMD_PERL_DEBUG ("ESM -> ++++  Welcome to Database data file permission check Debugging ++++ ");
  }

  my $maxCount;
  my $limit = 0 ;
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $OSNAME = get_osType();
  
  if($OSNAME eq "WIN"){
    $maxCount = $ENV{NDMAXCOUNT} ;
  }else{
    $maxCount = $ENV{DMAXCOUNT} ;
  }
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

if (EMAGENT_isPerlDebugEnabled())
{
    EMD_PERL_DEBUG ("dbDataFilePerm: OS         = $OSNAME");
    EMD_PERL_DEBUG ("dbDataFilePerm: oracleHome = $oracleHome");
    EMD_PERL_DEBUG ("dbDataFilePerm: username   = $username");
    EMD_PERL_DEBUG ("dbDataFilePerm: address    = $address");
    EMD_PERL_DEBUG ("dbDataFilePerm: role       = $role");
    EMD_PERL_DEBUG ("dbDataFilePerm: maxCount   = $maxCount");
	EMD_PERL_DEBUG ("dbDataFilePerm: mode       = $mode");
}

  my $dsn = "dbi:Oracle:" ;
  my $property='oh_datafiles_perm'; #the property is nt_$property for mswin32.
  my $table = "dba_data_files";  
  my $value = "file_name";
  my $rowNum = 0 ;

  EMD_PERL_DEBUG ("dbDataFilePerm: property   = $property");
  
  my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
  my @dataFiles = getValue($dbh,$value,"", "",$table);
  close_db_connection($dbh);

  if($maxCount >= 0){
    splice(@dataFiles, $maxCount);
  }
  db_data_file_perm(@dataFiles);
  
  sub db_data_file_perm{
   my $fpath ;
   if($OSNAME ne "WIN"){
       my $retMode ;
       foreach $fpath (@_) {
        $retMode = file_perm($fpath); 
        if($retMode >= 0) { #file_perm returns -1 in case of failure

# $retMode & 0777 means that you take the value of return mode (which is file permissions + file type) and Bitwise-And it with an octal-representation number of 777 (e.g. decimal 511, e.g. binary 111111111). What this does technically is removes any bits from an integer above the 9th bit, so if the mode binary representation was >9 bits, it would, after this operation, leave only the last 9 bits, representing the main permissions (read/write/execute for other/group/user).
# In other words, it DOES contain data above 9th bit, but only last 9 bits represent permissions data which is what the code above is after. To be more precise, the last 12 digits represent permissions (so the code should instead be doing & 07777) but bits 10-12 represent special permission bits unrelated to user/group/other read/write/execute perms (e.g. setuid, is_directory).

# Example
# -------
# $RetMode:   xxxxxxxxxxxxxxxxxx
# 0777:       000000000111111111
# Result:     000000000xxxxxxxxx

         $retMode = $retMode & 0777; 

# $retMode & 006 tests two of the bottom 3 bits and returns true (a number other than 0) if these bits correspond to the numbers 2, 3, 4, 5, 6, 7

# $retMode & 006 has similar mechanics, but different purpose. 006 octal is 110 in binary so it basically takes the mode bit vector and leaves only bits in 2/3 positions. Since the result is used in a boolean context, it will merely check whether the resulting # is non-zero, meaning if ONE of those 2 bits was set to 1.
# Please note that & 006 is actually BAD coding style since it is not obvious which bits are which perms (as I tried to subtly hint at by not explaining what bits 2/3 mean in the paragraph above). Instead you should import symbolic mode constants (S_IF* ) and functions (S_IS* ) from the Fcntl module:

# use Fcntl ':mode';
# $retMode = $retMode & 0777; # Ignoring setuid and directory bits
# $other_read_or_write = $retMode & (S_IWOTH || S_IROTH); 
                                  # Bits 2/3 - Other read/write
# if ($other_read_or_write) {
#    printf "$property|%03o|$fpath\n",$retMode; 
# }

# Example
# -------
# $RetMode:   000000000xxxxxxxxx
# 006:        000000000000000110
# Result:     000000000000000xx0



         if(($retMode & 022)) { 
           #$permString = rwx_string($retMode);
           $fpath  = check_512char($fpath);
           EMD_PERL_DEBUG("em_result=$property|%03o|$fpath");
           printf "em_result=$property|%03o|$fpath\n",$retMode;
           $rowNum++;
         } 
        }
       }
   }
   elsif($OSNAME eq "WIN"){
    foreach $fpath (@_){
        my $users = win32_file_perm($fpath);

# Return the list of users who have critical permission on the file. By critical permission we mean the user has one of these rights on the file (DELETE) || (WRITE_DAC) || (WRITE_OWNER) || (CHANGE) || (ADD) || (FULL)

        if($users == -1 || $users eq "0()") {next;}
        EMD_PERL_DEBUG("em_result=$property|$users|$fpath");
        print "em_result=nt_$property|$users|$fpath\n";
    }
   }
  }
   
