#!/usr/local/bin/perl
# 
# $Header: dbDynProOnOpen.pl 17-dec-2007.21:05:00 rtakeish Exp $
#
# dbDynProOnOpen.pl
# 
# Copyright (c) 2007, Oracle. All rights reserved.  
#
#    NAME
#      dbDynProOnOpen.pl
#
#    DESCRIPTION
#      It connects to a database, computes Dynamic Property with a SQL
#      on OPEN state database and reports success/failure
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rtakeish    12/17/07 - bug6442193, Computing dynamic property for standby
#                           DB causes ORA-01219
#    rtakeish    12/17/07 - Creation
# 

use strict;
use Oraperl;
use Time::HiRes;
use DBI;
use DBI qw(:sql_types);

require "emd_common.pl";

my %stdinArgs = get_stdinvars();

my $username = $stdinArgs{"EM_TARGET_USERNAME"};
my $password = $stdinArgs{"EM_TARGET_PASSWORD"};

my $address = $ENV{EM_TARGET_ADDRESS};
my $role = $ENV{EM_TARGET_ROLE};
my $sqlStatement = $ENV{EM_SQLSTATEMENT};

my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

my $lda;
unless ( $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password",
                            {ora_session_mode => $mode,
                             PrintError => 0,
                             RaiseError => 0}) )
{
   die "$ora_errstr\n";
}

register_metric_call($lda);

# sysdba and > 8i database

my $result;
my $state = "OPEN";

#Check status on v$instance for SYSDBA role 
#since the status could be MOUNTED
if ($mode == 2)
{
  # query the v$instance for db status
  my $sql = "SELECT status FROM v\$instance";
  my $cur = &ora_open ($lda, $sql) || warn "ora_open ($lda, $sql): $ora_errno: $ora_errstr\n";
  my @fetch_row = &ora_fetch($cur);
  &ora_close($cur)  || warn "ora_close($cur): $ora_errno: $ora_errstr\n";
  $state = $fetch_row[0];
}

if ($state =~ /OPEN/i)
{
  my $curd = &ora_open ($lda, $sqlStatement) || warn "ora_open ($lda, $sqlStatement): $ora_errno: $ora_errstr\n";
  my @fetch_rowd = &ora_fetch($curd);
  &ora_close($curd)  || warn "ora_close($curd): $ora_errno: $ora_errstr\n";
  foreach (@fetch_rowd)
  {
    $result = $result . $_ . "|";
  }
}
&ora_logoff($lda) || warn "ora_logoff($lda): $ora_errno: $ora_errstr\n";

print "em_result=$result\n";

exit 0;

