#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/dbInitParamFilesPerm.pl /main/16 2011/07/29 23:36:01 hpalitan Exp $
#
# dbInitParamFilesPerm.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbInitParamFilesPerm.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    07/20/11 - Bug #12764760
#    hpalitan    02/17/11 - Use get_osType()
#    manosing    12/28/06 - flood control for windows policy
#    manosing    12/21/06 - adding check for  "0()" 
#    kganapat    11/28/07 - XbranchMerge kganapat_filter_ora_errs from main
#    dsukhwal    12/22/05 - XbranchMerge dsukhwal_bug-4870607 from main 
#    dsukhwal    12/08/05 - add windows default init.ora location 
#    dsukhwal    05/04/05 - handle win32 cases 
#    dsukhwal    02/15/05 - exceptional cases in file_perm usage 
#    dkjain      12/28/04 - Removed check_permission 
#    dkjain      12/10/04 - Fixed Bug-4033921 
#    dkjain      10/31/04 - Fixed unable to connect
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 
  require "emd_common.pl";
  require "semd_common.pl";
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  require "find_os.pl";

  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $dbSid = $ENV{DB_SID};
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $spMax;
  my $inMax;
  my $OSNAME = get_osType();

  if($OSNAME eq "WIN"){
    $spMax = $ENV{'NSPFILEMAX'};
    $inMax = $ENV{'NINITORAMAX'};
  }else{
    $spMax = $ENV{'SPFILEMAX'};
    $inMax = $ENV{'INITORAMAX'};
  }
  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }
  my $dsn = "dbi:Oracle:" ;
  my $property1 ="oh_initora_perm"; #the properties are nt_$property for mswin32.
  my $property2 ="oh_spfileora_perm";

  EMD_PERL_DEBUG("dbInitParamFilesPerm: OS         = $OSNAME");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: oracleHome = $oracleHome");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: spMax      = $spMax");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: inMax      = $inMax");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: property1  = $property1");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: property2  = $property2");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: username   = $username");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: dbSid      = $dbSid");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: role       = $role");
  EMD_PERL_DEBUG("dbInitParamFilesPerm: mode       = $mode");
  
  my $table = "v\$parameter";  
  my $value = "value";
  my $name = "name"; 
  my $fp1 ; 
  my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
  #my @fp1 = getValue($dbh,$value,$name, "pfile",$table);
  #collect the perm for init from the default dir $OH/dbs

  my @fp2 = getValue($dbh,$value,$name, "spfile",$table);

  
  if($OSNAME eq "WIN") {
    $table = "v\$version" ;
    my $sth = $dbh->prepare_cached("SELECT banner FROM $table where banner like '%Oracle%' ")
          or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr",  $dbh->err)) ;
    $sth->execute()
          or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr",  $sth->err)) ;
    my @edition = $sth->fetchrow_array();
    if( ($edition[0] =~ m/10g/) && !(($edition[0] =~ m/10\.1/)) ){#should match 10gR2 and above
                                                     #will need modification after rdbms version 11
        $fp1 = "$oracleHome\\database\\init$dbSid.ora";
    }
    else{
        my @db_name = getValue($dbh, "value","name", "db_name", 'v$parameter');
        $fp1 = "$oracleHome\\admin\\".$db_name[0]."\\pfile\\init$dbSid.ora";
    } 
  }
  else {
   $fp1 = "$oracleHome/dbs/init$dbSid.ora"; #default location and default name for unixes
  }
  #test();
  close_db_connection($dbh);
  
  collect_init_files_perm($fp1,$property1,$inMax); #Output string for P1 init.ora
  collect_init_files_perm($fp2[0],$property2, $spMax); #Output string for P2 spfile.ora

  sub test{
    $table = "v\$version" ;
    my $sth = $dbh->prepare_cached("SELECT banner FROM $table where banner like '%Oracle%' ")
          or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)) ;
    $sth->execute()
          or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err)) ;
    my @edition = $sth->fetchrow_array();
    my @db_name = getValue($dbh, "value","name", "db_name", 'v$parameter');
    my $fp1 = "$oracleHome\\admin\\".$db_name[0]."\\pfile\\init$dbSid.ora";
    print "em_result=10.1 and below|$fp1|NA\n";
    $fp1 = "$oracleHome\\database\\init$dbSid.ora";
    print "em_result=10.2 and above|$fp1|NA\n";
  }
    

  sub collect_init_files_perm{
    my ($fpath,$property,$maxCount) = @_;
    if($maxCount == 0){#only one row each is to be printed for init.ora and spfile
        return;
    }
	if($OSNAME eq "WIN"){
        my $users = win32_file_perm($fpath);
        if($users == -1 || $users eq "0()"){
            return;#failed to get the file permissions
        }
        print "em_result=nt_$property|$users|$fpath\n";
    }
    else{
        my $retMode =  file_perm($fpath);
        if($retMode < 0)
        { return ; } 
    
        $retMode = $retMode & 0777 ; 
        if(($retMode & 006)){
          #$permString = rwx_string($retMode);  
          $fpath = check_512char($fpath);
          printf "em_result=$property|%03o|$fpath\n",$retMode ;  
        }
    }
  }
