#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/dbOsAuthentication.pl /main/13 2011/07/29 23:36:01 hpalitan Exp $
#
# dbOsAuthentication.pl
# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbOsAuthentication.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    07/20/11 - Bug #12764760
#    hpalitan    02/17/11 - Use get_osType()
#    dsukhwal    12/10/05 - XbranchMerge dsukhwal_bug-4744601 from main 
#    dsukhwal    11/16/05 - include util script:bug 4725586 
#    dsukhwal    12/10/05 - Backport dsukhwal_bug-4744601 from main 
#    dsukhwal    11/16/05 - include util script:bug 4725586 
#    dsukhwal    01/12/06 - correct registry handling
#    dsukhwal    11/16/05 - include util script:bug 4725586 
#    dsukhwal    07/04/05 - support flood control 
#    dkjain      07/03/05 - Fixd the bug 4422016 
#    dkjain      11/08/04 - corrected env parameter name for target oraclehome 
#    dkjain      10/08/04 - dkjain_esa_impl_init
#    dkjain      10/08/04 - Creation
# 

require "find_os.pl";

my $OSNAME = get_osType();
my $maxRow=$ENV{"OSAUTHMAX"};

if(($OSNAME ne "WIN")){
    exit(0);#This metric is defined for Windows
}
require "db/esaUtils.pl";
if(!compareNegInf(0,$maxRow))
{
  exit ;
}

my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
#Assuming that oracle.key file will always be there in bin directory of Oracle Home.
my $o_key_file= "$oracleHome\\bin\\oracle.key";
my $oracle_key_name ;

open ( FILE, $o_key_file) or die print "em_error=Cannot open file: $!\n";
chomp ( ($oracle_key_name = <FILE>) );
$oracle_key_name =~ s/\\/\//g;
my $property="osauth_prefix_domain" ;
my $data ;
  
$pound= $Registry->Delimiter("/");
$oraKey= $Registry->{"HKEY_LOCAL_MACHINE/$oracle_key_name"};

my %hash =  %$oraKey;
my %subhash = $hash{"/OSAUTH_PREFIX_DOMAIN"};
foreach $newKey (keys %subhash){
  $data = $newKey;	
}
if(((defined $data)) && (!($data eq "")) ){
  print "em_result=$property|$data|NA\n";
}

