#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/db_init_paramCollector.pl /main/1 2011/04/21 11:06:49 glavash Exp $
#
# db_init_paramCollector.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      db_init_paramCollector.pl - Collection script for db_init_param.
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    glavash     03/28/11 - ocm file
#    glavash     12/14/07 - add count check on columns
#    glavash     12/13/07 - use parse_db_metric sub
#    dkapoor     08/16/06 - Creation
# 
use strict;
require "$ENV{EMDROOT}/sysman/admin/scripts/emd_common.pl";
require "$ENV{EMDROOT}/sysman/admin/scripts/ccr/ccr_common.pl";

my ($configFile) = @ARGV;

my $metric = $ENV{Metric};
my $columnCount = $ENV{MetricColumnCount};
my $sid = $ENV{SID};

#Custom handle for db_init_param
my $customHandler = \&db_initPrintResult;

my $dbVersion = getDBVersionFromDBll($configFile);

EMD_PERL_DEBUG("db version=$dbVersion");
if($dbVersion ne '')
{
  $dbVersion = substr($dbVersion,0,3);
  #If the db version is not 9.2, don't use custom handling.
  if($dbVersion ne "9.2")
  {
     EMD_PERL_DEBUG("Not a 9.2 DB , handle differently");
     $customHandler = '';
  }
  
}

if($customHandler eq '')
{
  #Print the config metric result
  printConfigMetricResult($configFile,$metric,$columnCount,$sid);
}
else
{
  #Handle the config metric result using
  #our custom function to parse the result before printing
  handleConfigMetricResult($configFile,$metric,$columnCount,$sid,$customHandler);
}

#Check if param is "filesystemio_options"
#Check for more than excepted values for this parameter.
#If so, truncate the rest of the values.
#This is needed for 9.2 database because of the bug#2763984
#in the database server. Due to this bug more than the value gets returned when 
#getting te value for this paremeter.
sub db_initPrintResult
{
  my ($result) = @_;

  if(length($result) != 0)
  {
    EMD_PERL_DEBUG("In db_initPrintResult for [$result]");
    #Check if this is filesystemio_options param
    if( $result =~ /^em_result=filesystemio_options\|/i)
    {
       EMD_PERL_DEBUG("Found a filesystemio_options.");
       #Now get the values for this param
       if( $result =~ /^em_result=filesystemio_options\|.*/i)
       {
         # hard code version to be 10.2.7.1.0
         # because escape conversion occurred in the handler
         # if needed already
         my @col_values = parse_db_metric($result,"10.2.7.1.0");
         
         my $columns = scalar(@col_values);

         if ($columns >= 3)
         {
           my $value = $col_values[1];
           my $i;

           $result = 'em_result=filesystemio_options';
           #Now match the starting of the value to possible 4 set of
           #valid values
           #if matches, use the valid valid otherwise empty it out.
           if ($value =~ /^async(.*)$/i)
           {
            $value = 'asynch';
           }
           elsif($value =~ /^none(.*)$/i)
           {
              $value = 'none';
           }
           elsif ($value =~ /^directIO(.*)$/i)
           {
              $value = 'directIO';
           }
           elsif ($value =~ /^setall(.*)$/i)
           {
              $value = 'setall';
           }
           else
           {
              $value = '';
           }
           $result = $result . '|' . $value ;
           # append the rest of the data with embedded # and | escaped
           for ($i=2; $i < $columns; $i++)
           {
              $result = $result . '|' . escape_pipe_and_pound($col_values[$i]);
           } 
         }
       }
     }
    print "$result\n";
    EMD_PERL_INFO("Printed:$result");
  }
}

