#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/dbaGroupAssign.pl /main/10 2011/03/10 05:04:21 hpalitan Exp $
#
# dbaGroupAssign.pl
# 
# Copyright (c) 2005, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dbaGroupAssign.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    02/17/11 - Use get_osType()
#    denath      10/02/08 - Backport denath_bug-6930045 from main
#    dsukhwal    12/10/05 - XbranchMerge dsukhwal_bug-4744601 from main 
#    hpalitan    10/01/10 - Bug #10149304
#    dsukhwal    11/17/05 - fix for windows
#    dsukhwal    12/10/05 - Backport dsukhwal_bug-4744601 from main 
#    dsukhwal    11/17/05 - fix for windows
#    dsukhwal    02/01/05 - dsukhwal_reports2
#    dsukhwal    01/27/05 - Creation
#

use strict;

require "find_os.pl";

my @mem;
my $OSNAME = get_osType();

# EMD_PERL_DEBUG ("dbaGroupAssign: OS         = $OSNAME");

if($OSNAME eq "WIN"){
    require "db/esaUtils.pl";
	my $grpName = 'ORA_DBA';
	LocalGroupGetMembersWithDomain('127.0.0.1', $grpName, \@mem);
}
else{
	my ($name, $passwd, $gid, $members) = getgrnam("dba");
	@mem = split(/ /, $members);
}

# Code to remove duplicate entries
my %hash   = map { $_, 1 } @mem;
@mem = keys %hash;

my $i;

foreach $i (@mem)
{
  chomp($i);
  if ($i ne "") {
   print "em_result=$i|DBA Group|DBA_GROUP\n";
  }
}
  
