#  $Header: emdb/sysman/admin/scripts/db/dbusage.pl /st_emdbgc_10.2.0.1.0/1 2009/03/11 06:08:43 pnayak Exp $
# 
# Copyright (c) 2001, 2002, Oracle Corporation.  All rights reserved.  
#
#    NAME
#      dbusage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ychan       09/18/02 - ychan_move_dbscript
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    swexler     03/25/02 - Creation
#

#utility functions
sub convertTimeToSecs
{
    local($time) = @_;
    $secs = 0;
    @t_array = split(":", $time);
    if(@t_array == 3) {
	($h,$m,$s) = @t_array;
	$secs = ($h*3600);
    } else {
	($m, $s) = @t_array;
    }
    $secs += ($m*60)+$s;
    return $secs;
}

@procList = ();
@fullProcList = ();
%commands = ();
@splitArgs = ();
@cpuList = ();
$cputimeother=0;
$cputimedb=0;
$memdb=0;
$memother=0;

$cpucount=0;

$SID = $ARGV[0];


$ENV{PATH} = "/usr/bin:/usr/sbin";

# Get the type of Operating System
# This version only supports Solaris.

chomp ($os = `uname -s`)
    or die "Failed to run the uname command";

 SWITCH:
{
    $os eq "SunOS" && do
    {
	chomp ($ver = `uname -r`);
	if ( $ver !~ /^4./ )
	{

	    @procList = `/bin/ps -fe -o pid,ppid,time,vsz,args`
		or die "Failed to run ps\n";
	    @fullProcList = `/usr/ucb/ps -axgww`
		or @fullProcList = ();
	    shift @fullProcList;
	    
	    @cpuList = '/usr/sbin/psrinfo'
		or die "Failed to run psrinfo\n";
	    

	    last SWITCH;
	}
    };
    die "Unsupported Operating System\n";
}

shift @procList;

#print "$#procList\n";
#print "$#fullProcList\n";
#print "--->\n@procList<---procList\n";
#print "--->\n@fullProcList<--- fullProcList\n";

# associate full commands with pid's

foreach $full_line (@fullProcList)
{
    chomp($full_line);
    
    @splitLine = split (" ", $full_line, 5);
    $commands{$splitLine[0]} = $splitLine[4];
}

# Printing ....

$mypid = $$;
#print "$mypid\n";
#$count=0;

foreach $ps_line  (@procList)
{
   chomp($ps_line);   

   if ($ps_line eq '' )
   {
     next;
   }
   
   ($pid, $ppid, $time, $vsz, $comm)
       = split (" ", $ps_line);

       
   $time = convertTimeToSecs($time);
#   print "em_result=$pid|$ppid|$time|$vsz|";
	   
   if ($commands{$pid} ne "")
   {
     $comm = "$commands{$pid}";
   }

#     print "$comm\n";


   $ora = 'ora';
   $sidlength = length($SID);
   $lencomm = length($comm);
   $lendiff = $lencomm - $sidlength;

   $oracle = 'oracle';



   if (substr($comm, 0, 3) eq "$ora" &&
       substr($comm, $lendiff, $sidlength) eq "$SID")
   {
       $cputimedb += $time;
       $memdb += $vsz;
   }
   elsif (substr($comm, 0, 6) eq "$oracle" &&
	  substr($comm, 6, $sidlength) eq "$SID")
   {
       $cputimedb += $time;
       $memdb += $vsz;
   }
   else
   {
       
       $cputimeother += $time;
       $memother += $vsz;
   }



}

$memtotal = $memother + $memdb;
$memother = 100.0 * $memother / $memtotal;
$memdb = 100.0 * $memdb / $memtotal;



foreach $ps_line  (@cpuList)
{
   chomp($ps_line);   

   if ($ps_line eq '' )
   {
     next;
   }
   
   $cpucount++;
}


print "em_result=$cputimedb|$cputimeother|$memdb|$memother|$cpucount\n";


