--
-- $Header: emdb/sysman/admin/scripts/db/dfltAccPwd11.sql /main/3 2011/07/29 23:36:01 hpalitan Exp $
--
-- dfltAccPwd.sql
--
-- Copyright (c) 2006, 2011, Oracle and/or its affiliates. 
-- All rights reserved. 
--
--    NAME
--      dfltAccPwd.sql - <one-line expansion of the name>
--
--    DESCRIPTION
--      This script is used by the defaultAccountPasswords metric
--      in the database.xmlp. The sql checks for default accounts
--      with default passwords with the default account left 
--      unlocked.
--
--    NOTES
--      <other useful comments, qualifications, etc.>
--
--    MODIFIED   (MM/DD/YY)
--    hpalitan    07/20/11 - Bug #12764760
--    manosing    08/22/07 - sys.DBA_USERS_WITH_DEFPWD lists the users using dflt 
--    rmadampa    07/16/06 - This list has been copied from the DPS
--                           tool released in April 2006 CPU to fix
--                           bug 5257531.
--    rmadampa    07/16/06 - Created
--


SELECT  'Default account uid/pwd', u.username, 'NA'
FROM sys.DBA_USERS_WITH_DEFPWD dp, sys.DBA_USERS u
WHERE dp.username=u.username
AND u.account_status NOT IN ('EXPIRED & LOCKED' , 'LOCKED')
AND rownum <= decode(:1,'-1',2147483647,:1)
ORDER BY username
