#  $Header: emdb/sysman/admin/scripts/db/dg/dgGetPrimary.pl /main/7 2010/07/18 00:53:21 prapatil Exp $
#
# Copyright (c) 2002, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      dgGetPrimary.pl
#
#    DESCRIPTION
#      This metric test determines the primary database name for a standby database in a Data Guard configuration.
#
#    OUTPUT:
#	For 9i:
#	Not Supported
#
#	For 10g and up:
#	Primary DB Name
#
#    NOTES
#      DBI handles automatic error checking.
#
#    MODIFIED   (MM/DD/YY)
#      rimmidi     05/04/08 - Code slap from 11GC to 10.2.0.5
#      ngade       05/25/07 - fix bug 5951219
#      sjconnol   08/05/07 - Pass version to getPrmyDBName
#      sjconnol   08/15/06 - Use v$database PRIMARY_DB_UNIQUE_NAME for 11g
#      kramarat   12/03/04 - kramarat_new-topology
#      kramarat   11/03/04 - Creation
#

use strict;
use DBI;
use DBI qw(:sql_types);

require "emd_common.pl";
require "db/dg/dgutil.pl";

# RaiseError
$SIG{__DIE__} = \&handleError;
# PrintError
$SIG{__WARN__} = \&handleWarning;

# Trace the target name.
EMD_PERL_DEBUG("Database target=$ENV{EM_TARGET_NAME}");

# It should work for only 10g and higher
my $db_version = $ENV{VersionCategory};
verify_dbversion_10g($db_version);

# Connect to the instance.
my %stdinArgs = get_stdinvars();
my $username = $stdinArgs{EM_TARGET_USERNAME};
my $password = $stdinArgs{EM_TARGET_PASSWORD};
my $role = $ENV{EM_TARGET_ROLE};
my $mode = 0;
if($role =~ /SYSDBA/i)
{
  $mode = 2;
}
elsif($role =~ /SYSOPER/i)
{
  $mode = 4;
}

my $address = $ENV{EM_TARGET_ADDRESS};
my $lda = DBI->connect('dbi:Oracle:', "$username@".$address, "$password", {ora_session_mode => $mode, PrintError => 0, RaiseError => 1});

my $prmyname = getPrimaryDBName($lda, $db_version);
my $result = "em_result=$prmyname\n";  
print $result;
EMD_PERL_DEBUG("$result");

$lda->disconnect;

exit 0;


