#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/emergPerfUtil.pl /main/2 2012/03/20 22:32:18 pbhogara Exp $
#
# emergPerfUtil.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      emergPerfUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    pbhogara    03/23/11 - Creation
# 

use strict;

require "emd_common.pl";

package EmergPerfUtil;

use Time::Local;

#
# Subroutine: Replaces the special characters in the string with
#             predefined entity refs in XML. Following are the 5 
#             pre-defined entity refs:
#
#             &quot;  :  "
#             &amp;   :  &
#             &apos;  :  '
#             &lt;    :  <
#             &gt;    :  >
# 
#  $_[0]  => string for substituting special chars with entity refs.
#            If we pass "usn<<16 | slot" then it returns "usn&lt;&lt;16 | slot"
#
#  Returns: the new string after replacement
sub use_XML_entityrefs
{
  my $value = shift;
  $value =~ s/\&/\&amp;/g;
  $value =~ s/\</\&lt;/g;
  $value =~ s/\>/\&gt;/g;
  $value =~ s/\"/\&quot;/g;
  $value =~ s/\'/\&apos;/g;
  return $value;
}

sub trim
{
  my $str = shift;
  $str =~ s/^\s+//;
  $str =~ s/\s+$//;
  return $str;
}

# on windows sometimes chomp does not 
# remove new line. we ues this function
# to remove it.
sub trim_new_line
{
   my $str = shift;
   $str =~ s/(\r\n)+$//;
   $str =~ s/\n+$//;
   $str =~ s/\r+$//;
   return $str;
}

# 
# Subroutine: convert the date format to epoch time
#             This subroutine is used by dbIO and dbHost
#             scripts.
# 
#  $_[0] => Timestamp 
# 
# Returns: epoch time
#   
sub get_epoch_time
{
  my $ts = shift;

  my ($dd,$mm,$yy,$hh,$min,$sec) = ($ts =~ /(\d+)-(\d+)-(\d+)\s(\d+)\:(\d+)\:(\d+)/);
  my $epoch_time = timelocal($sec,$min,$hh,$dd,($mm-1),$yy);

  return $epoch_time*1000;

}

#
# Subroutine: findErrorCode
#  $_[0] => A line to be searched for error codes.
#
# Returns: returns "0" if no error code is found.
#          Otherwise returns the error code.
#
sub findErrorCode
{
  my $line = shift;
  if($line =~ /[A-Z][0-9a-zA-Z]{2}-([0-9]+)/)
  {
    return $1;
  }

  return 0;
}

1;
