#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/esaPrivReports.pl /main/7 2010/07/18 00:53:21 prapatil Exp $
#
# esaPrivReports.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      esaPrivReports.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      implement SYS_CONNECT_BY_PATH like output in 8i databases
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rrawat      09/12/07 - Bug-6130510
#    kganapat    12/03/07 - XbranchMerge kganapat_filter_ora_errs from main
#    dsukhwal    08/03/05 - dsukhwal_8i_reports
#    dsukhwal    08/03/05 - Creation
# 
  
  require "emd_common.pl";
  require "semd_common.pl";
  require "db/esaDbUtils.pl";
  require "db/esaUtils.pl";
  my %stdinArgs = get_stdinvars();
  my $username = $stdinArgs{"EM_TARGET_USERNAME"};
  my $password = $stdinArgs{"EM_TARGET_PASSWORD"};
  my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
  my $oracleOwner;
  my $dsn = "dbi:Oracle:" ;
  my $address = $ENV{EM_TARGET_ADDRESS};
  my $role = $ENV{EM_TARGET_ROLE};
  my $mode = 0;
  my $maxRows = 200;
  my $numRows = 0;

  if($role =~ /SYSDBA/i)
  {
    $mode = 2;
  }
  elsif($role =~ /SYSOPER/i)
  {
    $mode = 4;
  }

 my $table = "v\$database";  
 my $value = "log_mode";
 my $dbh = open_db_connection("dbi:Oracle:", "$username@".$address,$password,$mode); 
 my $sth; #to be used as a statement handle
 my $counter;  #to be used as a temp counter
 my @startkeys ; #to be used as the starting keys
 my $element;  #temp variable to hold the element
 my %dba_roles;
 my %usernames;
 
if($ARGV[0] eq 'EXEMPT_ACCESS_POLICY'){
     $sth = $dbh->prepare_cached( 'select role from dba_roles')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
     $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
     while ( $element = $sth->fetchrow_array()){
       $dba_roles{$element} = 1;
     }
     $sth = $dbh->prepare_cached( 'select username from dba_users')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
     $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
     while ( $element = $sth->fetchrow_array()){
       $username{$element} = 1;
     }
     $sth = $dbh->prepare_cached('select p, c from (
        select granted_role p,grantee c from dba_role_privs  union
        select privilege p,grantee c from dba_sys_privs) ')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('EXEMPT ACCESS POLICY');
}
elsif($ARGV[0] eq 'DBA_ROLE'){
    $sth = $dbh->prepare_cached('select p,c from (
        select granted_role  p, grantee c from dba_role_privs  union
        select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('DBA');
}
elsif($ARGV[0] eq 'CREATE_PRIVILEGE'){
    $sth = $dbh->prepare_cached(' select name  from system_privilege_map  where name like \'%CREATE%\' order by name asc')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    while ( $element = $sth->fetchrow_array()){
       unshift(@startkeys, $element);
    }
    $sth = $dbh->prepare_cached('select p, c from (
           select granted_role  p, grantee c from dba_role_privs  union
           select privilege p, grantee c from dba_sys_privs) ')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
}
elsif($ARGV[0] eq 'CATALOG_ROLE'){
    $sth = $dbh->prepare_cached('select role from dba_roles where role like \'%_CATALOG_%\' order by role asc')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    while ( $element = $sth->fetchrow_array()){
       unshift(@startkeys, $element);
    }
    $sth = $dbh->prepare_cached('select p,c from  (
           select granted_role p, grantee c from dba_role_privs   union
           select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
}
elsif($ARGV[0] eq 'BECOME_USER'){
    $sth = $dbh->prepare_cached('select distinct p,c from  (
           select granted_role p, grantee c from dba_role_privs  union
           select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('BECOME USER');
}
elsif($ARGV[0] eq 'AUDIT_SYSTEM'){
    $sth = $dbh->prepare_cached('select distinct p, c from (
            select granted_role p,grantee  c from dba_role_privs  union
            select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('AUDIT SYSTEM');
}
elsif($ARGV[0] eq 'ANY_DICTIONARY'){
    $sth = $dbh->prepare_cached('select name from system_privilege_map where name like \'%ANY DICTIONARY%\'') 
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    while ( $element = $sth->fetchrow_array()){
       unshift(@startkeys, $element);
    }
    $sth = $dbh->prepare_cached('select p, c from (
            select granted_role p, grantee c from dba_role_privs  union
            select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
}
elsif($ARGV[0] eq 'CONNECT_PRIVILEGE'){
    $sth = $dbh->prepare_cached('select distinct p, c from (
            select granted_role p, grantee  c from dba_role_privs  union
            select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('RESOURCE', 'CONNECT');
}
elsif($ARGV[0] eq 'ALL_PRIVILEGES'){
    $sth = $dbh->prepare_cached('select distinct p, c from (
            select granted_role p, grantee c from dba_role_privs  union
            select privilege p, grantee c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('GRANT ANY PRIVILEGE');
}
elsif($ARGV[0] eq 'ANY_PRIVILEGE'){
    $sth = $dbh->prepare_cached('select name from system_privilege_map where name like \'%ANY%\'')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute()
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    while ($element = $sth->fetchrow_array()){
            unshift(@startkeys, $element);
    }
    $sth = $dbh->prepare_cached('select distinct p, c from (
            select granted_role p, grantee c from dba_role_privs  union
            select privilege p, grantee  c from dba_sys_privs)')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
}
elsif($ARGV[0] eq 'POWER_PRIVILEGE'){
    $sth = $dbh->prepare_cached('select distinct p, c from ( 
            select granted_role p, grantee c from dba_role_privs  union 
            select privilege p, grantee c from dba_sys_privs) ')
            or die print (filterOraError("em_error=Couldn't prepare statement: $dbh->errstr", $dbh->err)); 
    $sth->execute() 
     or die print (filterOraError("em_error=Couldn't execute statement: $sth->errstr", $sth->err));
    @startkeys = ('ALTER SESSION','ALTER SYSTEM','CREATE PROCEDURE','CREATE LIBRARY');
}

my @grantList;
my @fetchrow_array;     #rows fetched from the database
my %fetchedrows_hash;   #Hashes of Arrays of all the rows fetched from database
my %childlList;         #to keep records the elements already found to avoid duplicacy
my @finalArray;         #Array to store the final result
my %grantTree;#grantTree{priv}=%privHash such that 
                        #%privHash{grantee} = 1 if priv has been granted to grantee, 
                                                    #undef otherwise
my $top;  #variable to store the top element poped from the startkeys
my $tempindex; #variable to keep the temporary index
my @temp_entry; #variable to store the temporary entry
my $check_index;  #variable to store the temporary check index
my $flag = 0; #used to check in the element is found
my $pos = 0;

$counter = 0;
while (@fetchrow_array = $sth->fetchrow_array()) {
  if ( !defined($fetchedrows_hash{$fetchrow_array[0]}) ) {
    $fetchedrows_hash{$fetchrow_array[0]}[0] = $fetchrow_array[1];
  }
  else {
    push @{ $fetchedrows_hash{$fetchrow_array[0]} }, $fetchrow_array[1];
  }
}


if( $ARGV[0] eq 'DBA_ROLE' or $ARGV[0] eq 'CREATE_PRIVILEGE'
    or $ARGV[0] eq 'CATALOG_ROLE' or $ARGV[0] eq 'ANY_DICTIONARY' or $ARGV[0] eq EXEMPT_ACCESS_POLICY)
{
  while(@startkeys)
  {
    if( $counter >=  1000)
    {
      last;
    }
    $top = pop @startkeys;
    $check_index = 0;
    if($top =~ /::\d/i)
    {
      @temp_entry = split/::/,$top;
      $top = $temp_entry[0];
      $check_index = $temp_entry[1];
    }
    $flag = 0;
    if( defined($fetchedrows_hash{$top}))
    {
       $tempindex = 0;
       for $elem ( @ {$fetchedrows_hash{$top}} )
       {
         $tempindex = $tempindex + 1;
         if( $counter >=  1000)
         {
            last;
         }
         if( $check_index != 0 and $tempindex <= $check_index)
         {
           next;
         }
         if(  $ARGV[0] eq 'EXEMPT_ACCESS_POLICY' )
         {
            if ($elem eq 'PUBLIC' or defined( $dba_roles{$elem}) or defined( $usernames{$elem}))
            {
              $finalArray[$counter][0] = $top ;
              $finalArray[$counter][1] = $elem ;
              $counter = $counter + 1;
              $flag = 1;
            }
         }
         if( $ARGV[0] ne  'EXEMPT_ACCESS_POLICY' )
         {
            $finalArray[$counter][0] = $top ;
            $finalArray[$counter][1] = $elem ;
            $counter = $counter + 1;
         }
        
         if( ($ARGV[0] ne  'EXEMPT_ACCESS_POLICY' and defined($fetchedrows_hash{$elem})) or
             ($ARGV[0] eq 'EXEMPT_ACCESS_POLICY' and  $flag == 1 and defined($fetchedrows_hash{$elem})))
         {
            push (@startkeys, $top."::$tempindex");
            push (@startkeys, $elem);
            $flag = 0;
            last;
         }
         $flag = 0;
       }
    }
  }
}
if( $ARGV[0] eq 'BECOME_USER' or $ARGV[0] eq 'AUDIT_SYSTEM'
    or $ARGV[0] eq 'CONNECT_PRIVILEGE' or $ARGV[0] eq 'ALL_PRIVILEGES'
    or $ARGV[0] eq 'ANY_PRIVILEGE' or $ARGV[0] eq 'POWER_PRIVILEGE' )
{
  #initialize the childList with startkeys to avoid duplicate records
  for $elem ( @startkeys )
  {
    $childlList{$elem} = 1;
  }
  while(@startkeys)
  {
     if( $counter >=  1000)
     {
        last;
     }
     @startkeys =  sort { $b cmp $a } @startkeys;
     $key = pop @startkeys;
     if( defined($fetchedrows_hash{$key}))
     {
        for $elem ( @ {$fetchedrows_hash{$key}} )
        {
          if( $counter >=  1000)
          {
             last;
          }
          $finalArray[$counter][0] = $key ;
          $finalArray[$counter][1] = $elem ;
          $counter = $counter + 1;
          if ( !defined ($childlList{$elem}))
          {
            $childlList{$elem} = 1;
            push(@startkeys, $elem);
          }
        }
     }
  }
}
    
for ($i = 0 ; $i < $counter; $i++)
{
    $grantList[0] = $finalArray[$i][0];
    $grantList[1] = $finalArray[$i][1];
    if( !defined($grantTree{$grantList[0]}) ){
        my %tempHash;
        $tempHash{$grantList[1]} = 1;
        $grantTree{$grantList[0]} = \%tempHash;
    }
    else{
        my %tempHash = %{$grantTree{$grantList[0]}};
        $tempHash{$grantList[1]} = 1;
        $grantTree{$grantList[0]} = \%tempHash;
    }
}
close_db_connection($dbh) ;
foreach $privs (keys %grantTree){
    my %tempHash = %{$grantTree{$privs}};
}
    
if(($ARGV[0] eq 'EXEMPT_ACCESS_POLICY') && defined($grantTree{"EXEMPT ACCESS POLICY"})){
        $numRows = $maxRows;
        printRows("EXEMPT ACCESS POLICY", "EXEMPT ACCESS POLICY", "EXEMPT_ACCESS_POLICY");
}
elsif(($ARGV[0] eq 'DBA_ROLE') && defined($grantTree{"DBA"})){
        $numRows = $maxRows;
        printRows("DBA", "DBA", "DBA_ROLE");
}
elsif($ARGV[0] eq 'CREATE_PRIVILEGE'){
    $numRows = $maxRows;
    my $create_priv;
    foreach $create_priv (keys %grantTree){
        if(($create_priv =~ /CREATE/) && defined($grantTree{$create_priv})){
            $numRows = $numRows - printRows($create_priv, $create_priv, 'CREATE_PRIVILEGE');
        }
    }
}
elsif($ARGV[0] eq 'CATALOG_ROLE'){
    $numRows = $maxRows;
    my $cata_role;
    foreach $cata_role (keys %grantTree){
        if(($cata_role =~ /_CATALOG_/) && defined($grantTree{$cata_role})){
            $numRows = $numRows - printRows($cata_role, $cata_role, 'CATALOG_ROLE');
        }
    }
}
elsif(($ARGV[0] eq 'BECOME_USER') && defined($grantTree{"BECOME USER"})){
        $numRows = $maxRows;
        printRows("BECOME USER", "BECOME USER", "BECOME_USER");
}
elsif(($ARGV[0] eq 'AUDIT_SYSTEM') && defined($grantTree{"AUDIT SYSTEM"})){
        $numRows = $maxRows;
        printRows("AUDIT SYSTEM", "AUDIT SYSTEM", "AUDIT_SYSTEM");
}
elsif($ARGV[0] eq 'ANY_DICTIONARY'){
    $numRows = $maxRows;
    my $dict_priv;
    foreach $dict_priv (keys %grantTree){
        if(($dict_priv=~ /ANY DICTIONARY/) && defined($grantTree{$dict_priv})){
            $numRows = $numRows - printRows($dict_priv, $dict_priv, 'ANY_DICTIONARY');
        }
    }
}
elsif($ARGV[0] eq 'CONNECT_PRIVILEGE'){
    $numRows = $maxRows;
    my $conn_priv;
    foreach $conn_priv (keys %grantTree){
        if((($conn_priv eq 'CONNECT') || ($conn_priv eq 'RESOURCE')) && 
          defined($grantTree{$conn_priv})){
            $numRows = $numRows - printRows($conn_priv, $conn_priv, 'CONNECT_PRIVILEGE');
        }
    }
}
elsif(($ARGV[0] eq 'ALL_PRIVILEGES') && defined($grantTree{"GRANT ANY PRIVILEGE"})){
        $numRows = $maxRows;
        printRows("GRANT ANY PRIVILEGE", "GRANT ANY PRIVILEGE", "ALL_PRIVILEGES");
}
elsif($ARGV[0] eq 'ANY_PRIVILEGE'){
    $numRows = $maxRows;
    my $any_priv;
    foreach $any_priv (keys %grantTree){
        if(($any_priv=~ /ANY/) && defined($grantTree{$any_priv})){
            $numRows = $numRows - printRows($any_priv, $any_priv, 'ANY_PRIVILEGE');
        }
    }
}
elsif($ARGV[0] eq 'POWER_PRIVILEGE'){
    $numRows = $maxRows;
    my $conn_priv;
    foreach $conn_priv (keys %grantTree){
        if((($conn_priv eq 'ALTER SESSION') || ($conn_priv eq 'ALTER SYSTEM') || ($conn_priv eq 'CREATE PROCEDURE') || ($conn_priv eq 'CREATE LIBRARY')) && 
          defined($grantTree{$conn_priv})){
            $numRows = $numRows - printRows($conn_priv, $conn_priv, 'POWER_PRIVILEGE');
        }
    }
}

sub printRows{
#The first argument is the privilege 
#starting from which we print the grant tree. Second argument is the prefix each line must 
#contain(which is the family lineage). Third argument is the report name to be printed along with the data.
#Fourth argument(only for recursive calls) is the number of rows already printed before the recursive call
#returns the number of rows printed
    my $startPriv = shift;
    my $prefix = shift;
    my $prop = shift;
    my $rowsPrinted = shift;
    if(!defined($rowsPrinted)){
        $rowsPrinted = 0;
    }
    if($numRows == 0){
        return;
    }
    #print "em_result=debug arg3|".rand()."|$prop\n";
    if(!defined($grantTree{$startPriv})){
        print "em_result=$prefix|$startPriv|$prop\n";
        $numRows--;
    }
    else{
        my %granteeHash = %{$grantTree{$startPriv}};
        foreach $grantee (keys %granteeHash){
            $rowsPrinted = $rowsPrinted + printRows($grantee, "$prefix->$grantee", $prop, $rowsPrinted);
        }
    }
    return $rowsPrinted;
}
