#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/getphysicalcpu.pl /main/7 2010/07/18 00:53:21 prapatil Exp $
#
# getphysicalcpu.pl
# 
# Copyright (c) 2005, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getphysicalcpu.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    nasounda    05/20/10 - Bug : 9719746 - Correcting the CPU count
#                           calculation on AIX
#    jsoule      12/11/07 - Fixing for hardcoded tab while greping in
#                           proc/cpuinfo
#    ssalunke    02/12/07 - Trimming cpunum
#    ssalunke    01/25/07 - Porting to other platforms
#    blivshit    08/25/05 - don't call the non-public ecm interface, call 
#                           agent's interface instead 
#    zsyed       04/12/05 - zsyed_dbcontrol_main_1
#    zsyed       03/30/05 - Creation
# 

require "emd_common.pl";
require "semd_common.pl";
require "db/db_common.pl";

use vars qw($NT);
use hostGenFunctions;

$perlbin = trim($ARGV[0]);
$scriptsdir = trim($ARGV[1]);

if($NT)
{
  my $orahome = $ENV{ORACLE_HOME};
  my $emdroot = $ENV{EMDROOT};

  if($emdroot eq "")
  {
    $emdroot = $orahome;
  }

  @cputext = `$emdroot/bin/nmeo.exe HARDWARE`;

  foreach $line (@cputext)
  {
    if($line =~ /NUMBER_OF_CPUS/)
    {
      @cpulinevalues1 = split(/>/, $line);
      @cpulinevalues2 = split(/</, $cpulinevalues1[1]);
      $cpunum = $cpulinevalues2[0];

      print "em_result=";
      print $cpunum;
      exit;
    }
  }
}
else
{
    # agent code doesn't work!
    # $cpunum = getCpuCount();
  my $os = `uname -s`;
  chomp ($os);
  if ( $os eq "SunOS" )
  {
    $cpunum = `/usr/sbin/psrinfo | wc -l`;
    if ($? != 0)
    {
      EMAGENT_PERL_DEBUG (" error during psrinfo");
      $cpunum=0;
    }
    $cpunum = trim($cpunum);
  }
  elsif ( $os eq "HP-UX" )
  {
    $cpunum = `/sbin/ioscan/ -kC processor | grep processor | wc -l`;
    if ($? != 0)
    {
      EMAGENT_PERL_DEBUG (" error during /sbin/ioscan/");
      $cpunum=0;
    }
    $cpunum = trim($cpunum);
  }
  elsif ( $os eq "AIX" )
  {
    $cpunum = `pmcycles -m | grep -i cpu | wc -l`;
    if ($? != 0)
    {
      EMAGENT_PERL_DEBUG (" error during pmcycles");
      $cpunum=0;
    }
    else
    {
      if ($cpunum == 0)
      {
        $cpunum = 1;
      }
      $cpunum = trim($cpunum);
    }
  }
  else 
  {
    my @processorLines = `grep '^processor[[:space:]]*:' /proc/cpuinfo`;
    if ($? != 0)
    {
        EMAGENT_PERL_DEBUG("grep of /proc/cpuinfo failed.");
        $cpunum=0;
    }
    else 
    {
        $cpunum = 0;
        foreach $line (@processorLines)
        {
            $cpunum++;
        }
  
        if ( $cpunum < 1 )
        {
            $cpunum = 1;
        }
    }
  }  
  print "em_result=";
  print $cpunum;
  exit;
}


sub trim {
 my $string = shift(@_);
 $string =~ s/\s//g;
 return $string;
}
