#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/installationdrv.pl /main/7 2011/07/29 23:36:01 hpalitan Exp $
#
# installationdrv.pl
# 
# Copyright (c) 2006, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      installationdrv.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    hpalitan    07/20/11 - Bug #12764760
#    hpalitan    02/17/11 - Use get_osType()
#    manosing    11/20/06 - Creation
#
#


use strict;

require "emd_common.pl";
require "db/esaUtils.pl";
require "find_os.pl";

my $oracleHome = $ENV{EM_TARGET_ORACLE_HOME};
my $OSNAME = get_osType();

my $maxRow=$ENV{"DRIVEPERM"};

	
if($maxRow==0){
   exit(0);
}

sub ACLs {
     my $driveLetter =shift;
    my $osVolName; my $ouSerialNum; my $ouMaxNameLen; my $ouFsFlags; my $osFsType;
    GetVolumeInformation( $driveLetter, $osVolName,'' , $ouSerialNum, $ouMaxNameLen, $ouFsFlags, $osFsType, 8 );
    if (!($osFsType =~ 'NTFS')){
        return -1;#the filesystem is not NTFS, forget about ACLs
    }

    my %hash;
    my $name;my $mask;my $entry;
    my %resultHash;
    my $count=0;
    
    if ( Get( $driveLetter, \%hash ) ) {
        while( ($name, $mask) = each %hash ) {
            
                my @rights;
                EnumerateRights($mask, \@rights );
                $resultHash{$name} = \@rights;
                $count+=@rights;
        }
    }
    return (\%resultHash, $count);
}


if($OSNAME eq "WIN"){

    my $driveLetter = $oracleHome;
    if (!($driveLetter =~ m/(.*):(.*)/)){
        exit(0); #Windows NT filenames without colons are not supported
    }
    $driveLetter  =~ s/(.*?)(:)(.*)/$1$2/;
    $driveLetter = $driveLetter."\\";
    my ($res, $numRows) =  ACLs($driveLetter); # we want all entries. Hoping 9000 is enough.
    if($res == -1){
        exit(0);
    }
    my %hash = %$res;   
    my $arrRef = $hash{"Everyone"};
    if($arrRef ne ""){
        print "em_result=drive_perm|Everyone|NA\n";
    }
}

