#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/migration/jobStatusUtil.pl /st_emgc_pt-12.1.0.4pg/7 2012/12/26 21:29:39 rtewari Exp $
#
# jobStatusUtil.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      jobStatusUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sresrini    11/10/11 - utility pl code to print job status
#    sresrini    11/10/11 - Creation
# 

#use strict;
#use warnings;
use DBI;
use Switch;

require "emd_common.pl";
require "semd_common.pl";
require "db/db_common.pl";
require "db/migration/sqlUtil.pl";
require "jobutil/JobDiagUtil.pm";

my ($dmpjobType,$dpjobname,$oracleHome,$host,$port,$oracleSID,$username,$passwd,$logfilename,$dbSID);
my $percdone = 0;
my $jobstate = 'UNDEFINED';

sub writeOutput
{
	($dmpjobType,$dpjobname,$oracleHome,$host,$port,$oracleSID,$username,$passwd,$logfilename,$dbSID) = @_;
	writePercDone();
}


sub getDPumpJobPercDone
{
	my $dbconn;
	my $js = "UNDEFINED";
	my $prcd = 0;
	if($dmpjobType eq "import")
	{
		$dbconn = getDBConnection($host,$port,$dbSID,$username,$passwd,$oracleSID);
	}
	else
	{
		$dbconn = getDBConnection($host,$port,$oracleSID,$username,$passwd);
	}
	$username = uc($username);
	my $stmt = "DECLARE\n";
	$stmt .= "  ind NUMBER;              -- Loop index\n";
	$stmt .=  " h1 NUMBER;               -- Data Pump job handle\n";
	$stmt .=  " percent_done NUMBER;     -- Percentage of job complete\n";
	$stmt .=  " job_state VARCHAR2(30);  -- To keep track of job state\n";
	$stmt .=  " js ku\$_JobStatus;        -- The job status from get_status\n";
	$stmt .=   "ws ku\$_WorkerStatusList; -- Worker status\n";
	$stmt .=   "sts ku\$_Status;          -- The status object returned by get_status\n";
	$stmt .= "BEGIN\n";
	$stmt .= "h1 := DBMS_DATAPUMP.attach(:jobname, :jobowner); -- job name and owner\n";
	$stmt .= "dbms_datapump.get_status(h1,\n";
	$stmt .= "           dbms_datapump.ku\$_status_job_error +\n";
	$stmt .= "           dbms_datapump.ku\$_status_job_status +\n";
	$stmt .= "           dbms_datapump.ku\$_status_wip, 0, :jobstate, sts);\n";
	$stmt .= "js := sts.job_status;\n";
	$stmt .= ":percentdone := js.percent_done;\n";
	$stmt .=  "DBMS_DATAPUMP.detach(h1);\n";
	$stmt .= "end;\n";
	my $plstmt = $dbconn->prepare( $stmt );
	$plstmt->bind_param(":jobname",$dpjobname);
	$plstmt->bind_param(":jobowner",$username);
	$plstmt->bind_param_inout(":percentdone",\$prcd,100);
	$plstmt->bind_param_inout(":jobstate",\$js,100);
	$plstmt->execute();
	$plstmt->finish();
	&closeDBConnection($dbconn);
	$jobstate = $js;
	$percdone= $prcd;
	#print("\nJobstate is $jobstate and percent done is $percdone\n");
}

sub writePercDone
{
	my $logfile;
	my $filedir;
	my $dbalertlog;
	if(($dmpjobType eq "import") or ($dmpjobType eq "export"))
	{
		$logfile = basename($logfilename);
		$filedir = dirname($logfilename);
		my $count = 0;
		$| =1;
		my $jobstarted = 0;
		#writeStepListXML($dmpjobType,$logfilename,$jobstate);
		my $checkagain = 1;
		while ($checkagain == 1) {
			&getDPumpJobPercDone();
			if($jobstate ne 'UNDEFINED')
			{
				if($jobstarted eq 1)
				{
					#Write job percent done as xml only if job has started , but has not yet finished
					writeXML("percentComplete",$percdone);
					writeXML("remoteLogsLocation",$filedir);
					writeXML("currentLogFile",$logfilename);
					writeXML("datapumpJobStatus",$jobstate);					
					writeStepListXML($dmpjobType,$logfile,remapDPJobStatus());
					my $errorfound = writeCurrentStepDetailsXML();		
					if($errorfound eq 1)
					{
						$checkagain = 0;
						exit -1;
					}
					JobDiagUtil::associateRemoteLogFiles($logfilename);
					$dbalertlog = getAlertLogName();
					writeXML("dbAlertLogFile",$dbalertlog);				
					JobDiagUtil::associateRemoteLogFiles($dbalertlog);
				}
				if($jobstarted eq 0)
				{
					$jobstarted = 1;
				}	
			}
			else
			{
				if($jobstarted eq 1) 
				{
					$jobstate = "COMPLETED";
					# The datapump job has completed
					writeXML("percentComplete",100);
					writeXML("remoteLogsLocation",$filedir);
					writeXML("currentLogFile",$logfilename);
					writeStepListXML($dmpjobType,$logfile,remapDPJobStatus());
					writeCurrentStepDetailsXML();					
					print "Datapump job completed ..\nPlease check the logs and verify.\n";
					$checkagain = 0;
				}
				else
				{		#increase the count if job has not yet started
						$count = $count + 1;
				}
			}

			if($count eq 8) 
			{
				#if job doesnot start for 2 min, exit loop
				print("datapump job not started in 2 minutes\n");
				$checkagain = 0;
			}
			if($checkagain == 1)
			{
				sleep 15;
			}
		}
	}
}

sub writeXML
{
	my ($param,$value) = @_;
	if(defined $value)
	{
		my $xmlstr = "\$\$\$--*\$\$";
		$xmlstr .="<commandBlock>";
		$xmlstr .= " <executeProc name=\"MGMT_JOBS.ADD_JOB_PARAMETERS\">" ;
		$xmlstr .= "  <scalar>%job_id%</scalar>" ;
		$xmlstr .= "  <scalar>%job_execution_id%</scalar>" ;
		$xmlstr .= "  <array>";
		$xmlstr .="<record>" ;
		$xmlstr .= " <scalar>$param</scalar>" ;
		$xmlstr .=" <scalar>1</scalar>";
		$xmlstr .=" <scalar><![CDATA[$value]]></scalar>" ;
		$xmlstr .= " <array>null</array>" ;
		$xmlstr .= " <scalar>0</scalar>" ;
		$xmlstr .="</record>";
		$xmlstr .= "  </array>" ;
		$xmlstr .= " </executeProc>" ;
		$xmlstr .= "</commandBlock>" ;
		$xmlstr .= "\$\$\$*--\$\$";
		print($xmlstr);	
	}
}

sub writeStepListXML
{
	my ($stepname,$logfile,$status) = @_;
	
	my $xmlstr .="<Steps>";
	$xmlstr .="<Step name=\"$stepname\" log=\"$logfile\" status=\"$status\"/>";
    $xmlstr .="</Steps>";
	writeXML("stepsList",$xmlstr);
}

#this remaps dp job status to what is known by EM to display grathically
sub remapDPJobStatus
{
	my $newjobstate;
	$newjobstate = "";
	switch ($jobstate)
	{
		case ("UNDEFINED") { $newjobstate = "PENDING";}
		case ("EXECUTING") { $newjobstate = "RUNNING";}
		case ("COMPLETED") { $newjobstate = "COMPLETED";}
		case ("ERROR") { $newjobstate = "FAILED";}
		else  { $newjobstate = "RUNNING";}
	}
	return $newjobstate;
}

sub writeCurrentStepDetailsXML
{
	#only 1 step in datapump job
	writeXML("currentStepIndex",0);
	writeXML("currentLogFile",$logfilename);
	my ($file, $limit) = ($logfilename, 10);
	open my $f, '<', $file or die;
	my @lines = ();
	$#lines = $limit;
	while( <$f> ) {
	  shift @lines if @lines >= $limit;
	  push @lines, $_;
	}
	my $logoutput="";
	$logoutput= join(" ",@lines);
	my $errfound = 0;
	my $srchStr = "^Job .* stopped due to fatal error";
	foreach(@str)
	{
		my $line = $_;
		if($line =~ m/$srchStr/i)
		{
			$errfound =  1;
		}
	}
	#print @lines;
	writeXML("currentLogText",$logoutput);
	return $errfound;
}

sub getAlertLogName
{
	my $alertlog="";
	if($dmpjobType eq "import")
	{
		$dbconn = getDBConnection($host,$port,$dbSID,$username,$passwd,$oracleSID);
	}
	else
	{
		$dbconn = getDBConnection($host,$port,$oracleSID,$username,$passwd);
	}
	my $logloc = "SELECT value FROM v\$parameter WHERE name = 'background_dump_dest'";
	my @logloc = execSQL($dbconn,$logloc);
	&closeDBConnection($dbconn);
	if(scalar(@logloc) == 0)
	{
		print ("\nCouldnot retrieve Alertlog location\n");
		exit(-1);
	}
	$alertlog = $logloc[0];
	if ( $alertlog =~ /\S/ ) {
		$alertlog .= "/alert_$dbSID.log";
	}
	return $alertlog;

}
