#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/migration/migration_utils.pl /st_emgc_pt-12.1.0.4pg/17 2012/12/26 21:29:38 rtewari Exp $
#
# migration_utils.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      migration_utils.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sresrini    10/09/12 - bug 14561773
#    sresrini    08/09/12 - bug 14470562
#    sresrini    07/26/12 - migration utilities
#    pracgoya    05/17/12 - expdp and impdp for encrypted dbs
#    pracgoya    03/29/12 - add code for zipping the exported files
#    sresrini    09/26/11 - migration utilities
#    sresrini    09/26/11 - Creation
# 
use strict;
use warnings;
use DBI;
use File::Basename;
use File::Path;
use Archive::Tar;
require "emd_common.pl";
require "semd_common.pl";
require "db/db_common.pl";
require "db/migration/sqlUtil.pl";
require "db/migration/jobStatusUtil.pl";
require "find_os.pl";

use vars qw/$hostUserID $OS $NT $S $TEMP $CP $MV $PS $DF $DELIMITER/;

#setenv PERL5LIB $SRCHOME/emagent/sysman/admin/scripts:$ADE_VIEW_ROOT/emdb/sysman/admin/scripts:$PERL5LIB

$ENV{'LD_LIBRARY_PATH'} = $ENV{'ORACLE_HOME'}."/lib";
#executeRMANCopyCommand("/ade/b/3844072407/oracle","adc2180780.us.oracle.com","15231","rd11a","sys","****","/tmp/migration/export/");
#executeRMANConvertAndCopyCommand("/ade/sresrini_nov9t/oracle","adc2180780.us.oracle.com","15045","tnov9","sys","****",$importDatafileList,$exportDbPlatform,$ImportDBPlatform,$importLoc,$datafileLoc);
#createPDB( "/ade/b/2784602824/oracle","cdb01","cdb01", "pdb102","pdbsys","oracle","/ade/b/2784602824/dbs/pdb103");
#exportDB("/ade/b/3844072407/oracle","rd11a","datapump_rd11a1_2011_10_27_1_30_36_742.dmp","datapump_rd11a1_2011_10_27_1_30_36_742.log","12","sys","****","EXPORT_rd11a","EXPORT_rd11a");
#importDB("/ade/b/2784602824/oracle","cdb01","datapump_rd11a2_2011_10_27_1_46_5_613.dmp","datapump_rd11a2_2011_10_27_1_46_5_613.log","12","sys","****","IMPORT_rd11a2","IMPORT_rd11a2","/ade/b/2784602824/dbs/pdbs/rd11at_db1.f,/ade/b/2784602824/dbs/pdbs/rd11at_ax1.f,/ade/b/2784602824/dbs/pdbs/rd11at_undo1.f","RD11A","1521");
my $rmanStepCompleted = "no";
my $OSNAME = get_osType();

sub exportDB
{
	my ($oracleHome,$host,$port,$oracleSID,$username,$passwd,$dumpDir,$dumpFile,$logDir,$logFile,$version,$dpjobname,$dmpDirLoc,$encryptPwd) =@_;
	my $role = "";
	 my $expcmd = "";
	chomp($dmpDirLoc);
	chomp($logFile);

	if(uc($username) eq "SYS")
	{
		$role = " AS SYSDBA";
	}
	$dpjobname = uc($dpjobname);
	my $connstr = "\\'$username/$passwd".$role."\\'";
	if($OSNAME eq "WIN"){
		$connstr = "'$username/$passwd".$role."'";
	}
	else 
	{
		$connstr = "\\'$username/$passwd".$role."\\'";
	}
	if(not defined $encryptPwd){
		 $expcmd = "$oracleHome/bin/expdp $connstr full=y job_name=$dpjobname dumpfile=$dumpFile DIRECTORY=$dumpDir LOGFILE=$logFile VERSION=12 transportable=always" ;
	}else {
		 $expcmd = "$oracleHome/bin/expdp $connstr full=y job_name=$dpjobname dumpfile=$dumpFile DIRECTORY=$dumpDir LOGFILE=$logFile VERSION=12 transportable=always ENCRYPTION_PASSWORD=$encryptPwd";
	}
	
	my $result = -1;
	my $commandType = "export";
	$| =1; #autoflush the STDOUT
	my $pid = fork();	
	if (not defined $pid) {
		print "resources not available to execute the $commandType command.\n";
	} elsif ($pid == 0) {
		&writeOutput($commandType,$dpjobname,$oracleHome,$host,$port,$oracleSID,$username,$passwd,$dmpDirLoc.$logFile,$oracleSID);
		exit(0);	
	} else {
		printCommand($expcmd,$username,$passwd);
		$result = &runCommand($expcmd,$oracleHome,$host,$oracleSID,$dmpDirLoc.$logFile);
		waitpid($pid,0);
	}
	
	return $result;
	
}
sub importDB
{
	my ($oracleHome,$host,$port,$oracleSID,$username,$passwd,$dumpDir,$dumpFile,$logDir,$logFile,$version,$dpjobname,$dmpDirLoc,$encryptPwd,$datafilelist,$pdbservicename,$srchost,$srcport,$srcsid,$srcuser,$srcpasswd,$walletPwd,$dfPrefix) =@_;
        my $result = -1;
	if (not defined $pdbservicename) {
		print "PDB Service name not found. Please check PDB Creation Step logs.";
	}
        else
        {
            chomp($dmpDirLoc);
            chomp($logFile);
            my $role = "";
            $dpjobname = uc($dpjobname);
            if(uc($username) eq "SYS")
            {
                    $role = " AS SYSDBA";
            }
            $ENV{'ORACLE_HOME'} = $oracleHome;
            $ENV{'ORACLE_SID'} = $oracleSID;
            $ENV{'LD_LIBRARY_PATH'} = $ENV{'ORACLE_HOME'}."/lib";
	    createDirObj($host,$port,$oracleSID,$username,$passwd,$dumpDir,$dmpDirLoc,$pdbservicename);
            if(defined $walletPwd)
            {
                openWallet($host,$port,$oracleSID,$username,$passwd,$walletPwd,$pdbservicename);
            }
            
            my $remapCmd = getRemapList($host,$port,$oracleSID,$pdbservicename,$username,$passwd,$srchost,$srcport,$srcsid,$srcuser,$srcpasswd);
            my $connectstring;
            if($OSNAME eq "WIN"){
                    $connectstring = "'$username/$passwd\@\"(DESCRIPTION =";
            }
            else 
            {
                    $connectstring = "\\'$username/$passwd\@\"(DESCRIPTION =";
            }
             
                    $connectstring .= "(ADDRESS = (PROTOCOL = TCP)(HOST = $host)(PORT = $port))";
                    $connectstring .= "(CONNECT_DATA =";
                    $connectstring .= " (SERVER = DEDICATED)";
                    $connectstring .= " (SERVICE_NAME = $pdbservicename)(INSTANCE_NAME=$oracleSID)";
                    $connectstring .= ")";
                    if($OSNAME eq "WIN"){
                            $connectstring .= ")\"$role' ";
                    }
                    else 
                    {
                            $connectstring .= ")\"$role\\' ";
                    }
                    
            my $impcmd = "$ENV{'ORACLE_HOME'}/bin/impdp  $connectstring";
             $impcmd .= " full=y";
            $impcmd .= " dumpfile=$dumpFile";
            $impcmd .= " DIRECTORY=$dumpDir";
            $impcmd .= " LOGFILE=$logFile";
            $impcmd .= " VERSION=$version";
	    #TODO: Remove when subfolders in ASM are available to be used as DF Loc
	    $datafilelist = addCdbPdbToDatafileName($datafilelist,$dfPrefix);
            $impcmd .= " TRANSPORT_DATAFILES=$datafilelist"  ;
            $impcmd .= " job_name=$dpjobname"  ;
            $impcmd .= $remapCmd;
            if(defined $encryptPwd){
                     $impcmd .= " ENCRYPTION_PASSWORD=$encryptPwd";
            }
            #print("command is \n$impcmd\n");
            my $commandType = "import";
            $| =1; #autoflush the STDOUT
            my $pid = fork();
            if (not defined $pid) {
                    print "resources not available to execute the $commandType command.\n";
            } elsif ($pid == 0) {
                    #print "Monitoring the execution as a separate process\n";
                    &writeOutput($commandType,$dpjobname,$oracleHome,$host,$port,$pdbservicename,$username,$passwd,$dmpDirLoc.$logFile,$oracleSID);		
                    exit(0);
            } else {
                    printCommand($impcmd,$username,$passwd);
                    $result = &runCommand($impcmd,$oracleHome,$host,$oracleSID,$dmpDirLoc.$logFile);
                    waitpid($pid,0);
            }
        }
	return $result;
}

sub executeRMANConvertAndCopyCommand
{	
    
        my($oracleHome, $host,$port,$sid,$username,$password,$destDir,$exportDBPlatform,$importDBPlatform,$excludeSysdatafiles,$isOMF,$datafiles,$pdbservice,$logDir,$dfPrefix) = @_;
		my @datafilelist;
		my $result;
		if(defined  $datafiles)	{
			my @datafilesp = split(',',$datafiles);
			my $i=0;
			foreach(@datafilesp)
			{
				my $filename = $_;
				$filename =~ s/'//g;
				push(@datafilelist,$i++,$filename);
			}
		} else {
			@datafilelist = getDatafileList($host,$port,$sid,$username,$password,$excludeSysdatafiles);
		} 
		my $hasOMFDatafiles = "N";
		my $firststr = substr($destDir,0,1);
		foreach  (@datafilelist) {
			my($filename, $dataFileLoc, $suffix) = fileparse( $_);
			if($filename =~ m/^o1_mf.*_.dbf$/i)
			{
				$hasOMFDatafiles =  "Y";
			} else {				
				if($firststr eq "+")
				{
					$hasOMFDatafiles =  "Y";
				}
			}
		}

		if (((not defined $isOMF)|| ($isOMF eq "N")) && ($firststr ne "+")) {
			mkpath($destDir, 1);
		} else {
			if (defined $pdbservice) {
				$destDir = getPDBOMFLocation($host,$port,$sid,$username,$password,$pdbservice);
				$hasOMFDatafiles = "Y";
			}			
		}
		
       	my $rmancmd = getRMANConvertAndCopyCommand($host,$port,$sid,$username,$password,$destDir,$exportDBPlatform,$importDBPlatform,$excludeSysdatafiles,$hasOMFDatafiles,$dfPrefix,@datafilelist);
		printCommand($rmancmd,$username,$password);
		$result = &runRmanCommand($oracleHome,$rmancmd,$logDir);
        if ($hasOMFDatafiles eq "Y") {
            renamefilestoOrig($host,$port,$sid,$username,$password,$destDir,$dfPrefix,@datafilelist);
	}
	return $result;
}


sub getPDBOMFLocation
{
	my($host,$port,$cdbsid,$username,$password,$pdbservice)=@_;
	my $dbconn = getDBConnection($host,$port,$cdbsid,$username,$password,$pdbservice);
    my $dfsql = "SELECT FILE_NAME FROM DBA_DATA_FILES WHERE ROWNUM=1"; 
	my @omfloc = execSQL($dbconn,$dfsql) or die "could not get pdb's omf location\n";
    &closeDBConnection($dbconn);
	my $fullDataFileName = $omfloc[0];
	#my $dataFileLoc =  dirname($dataFileName);
	my($filename, $dataFileLoc, $suffix) = fileparse($fullDataFileName);
	print("\nPDB\'s Datafile location is $dataFileLoc\n");
	return $dataFileLoc;
}

sub renamefilestoOrig
{
	my($host,$port,$sid,$username,$password,$destDir,$prefix,@datafilelist) = @_;
	#print ("\nrenamefilestoOrig params are : $host,$port,$sid,$username,$password,$destDir,$prefix, \narray datafile list : @datafilelist\n");
	my $nodatafiles = scalar(@datafilelist);
   
	my $i= 0;
	for ($i = 0; $i<$nodatafiles; $i+=2)
	{
		my $existingname = $datafilelist[$i]; #copied as fileid
		my $fullFileName = $datafilelist[$i+1];
		my $origfilename = basename($fullFileName);
		my $oldfullfilename = $destDir . $existingname;
		my $newfullfilename = $destDir . $origfilename;
		if(defined $prefix)
		{
			$newfullfilename = $destDir . $prefix . $origfilename;
		}
		my $firststr = substr($destDir,0,1);
		if($firststr eq "+")
		{
			EMD_PERL_DEBUG("Renaming $oldfullfilename to $newfullfilename...");
			my @dirs = split(/\//, $destDir);
			my $diskgroup = substr($dirs[0],1);
			my $dbconn = getDBConnection($host,$port,$sid,$username,$password);
			my @fln = split('\.',$newfullfilename);
			my $nooc = scalar(@fln);
			if($nooc > 2)
			{
				$newfullfilename .= "_1";
			}
			my $dfquery = " ALTER DISKGROUP $diskgroup RENAME ALIAS '$oldfullfilename'  TO '$newfullfilename'";
			if( $dbconn->do($dfquery))
			{
				EMD_PERL_DEBUG("Renamed datafile to $newfullfilename successfully.");
			} else
			{
				EMD_PERL_DEBUG("Could not rename datafile $dfquery, $DBI::errstr");
			}
			&closeDBConnection($dbconn);
		}
		else
		{
			EMD_PERL_DEBUG("Renaming $existingname to $origfilename...");
			chdir($destDir);   			
			rename  $existingname,$origfilename;
		}
	}

}

sub getDatafileList
{
        my($host,$port,$sid,$username,$password,$excludeSysdatafiles) = @_;	
        my $dbconn = getDBConnection($host,$port,$sid,$username,$password);
        my $excludeQry = "' '";
        if ((defined $excludeSysdatafiles) && ($excludeSysdatafiles eq ("TRUE")))  {
                $excludeQry = "'SYSTEM','SYSAUX'";
        }
         my $dfquery = "SELECT FILE_ID,FILE_NAME FROM DBA_DATA_FILES WHERE TABLESPACE_NAME IN (SELECT TABLESPACE_NAME FROM DBA_TABLESPACES WHERE CONTENTS = 'PERMANENT' AND TABLESPACE_NAME NOT IN ($excludeQry))";
        my @datafilelist = execSQL($dbconn,$dfquery);
        &closeDBConnection($dbconn);
        return @datafilelist;
}

sub getRMANConvertAndCopyCommand
{
	my($host,$port,$sid,$username,$password,$destDir,$exportDBPlatform,$importDBPlatform,$excludeSysdatafiles,$isOMF,$dfPrefix,@datafilenum) = @_;	
	my $connstr = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=$host)(PORT=$port))(CONNECT_DATA=(SID=$sid)))";
	my $rman_string = "CONNECT TARGET $username/$password\@$connstr\n";
	$rman_string .= "run\n{\n";
	my $nodatafiles = scalar(@datafilenum);
        my $sep = "\/";
	if($OSNAME eq "WIN"){
		$sep = "\\";
	}
	my $dir = $destDir;
	if (index((reverse $dir),$sep) != 0)
	{
		$destDir .= $sep;
	}
	my $i= 0;
	
    for ($i = 0; $i<$nodatafiles; $i+=2)
	{
		my $fileID = $datafilenum[$i];
		my $fullFileName = $datafilenum[$i+1];
		my $filename = basename($fullFileName);
		my $filedir = dirname($fullFileName);
		my $destfilename = $filename;
		if ((defined $isOMF) && ($isOMF eq "Y")) {
			$destfilename = $fileID;
		}
		elsif (index($destDir,"+") == 0 && defined $dfPrefix)
		{
			$destfilename = $dfPrefix.$destfilename;
		}
		if(defined $importDBPlatform)
		{
			$rman_string .= "CONVERT DATAFILE '$fullFileName' FROM PLATFORM='$exportDBPlatform' TO PLATFORM='$importDBPlatform'  DB_FILE_NAME_CONVERT=\"$fullFileName\",\"$destDir$destfilename\" FORMAT=\'$destDir$destfilename\';\n";
		}
		elsif(@datafilenum)
		{
			$rman_string .= "CONVERT DATAFILE '$fullFileName'  DB_FILE_NAME_CONVERT=\"$fullFileName\",\"$destDir$destfilename\" FORMAT=\'$destDir$destfilename\';\n";
		}
		else
		{
			$rman_string .= "copy datafile $fileID to '$destDir$destfilename';\n";
		}
	}
	$rman_string .= "} \n";
     return $rman_string;

}

sub runRmanCommand
{
	$ENV{'ORACLE_HOME'} = $_[0];
	$ENV{'LD_LIBRARY_PATH'} = $ENV{'ORACLE_HOME'}."/lib";
	my $rman_script = $_[1];
	my $logdir = $_[2];
        my $rman_filename = $logdir."/rman.log";

	open(RMAN_WRITER, "|$ENV{ORACLE_HOME}/bin/rman log=$rman_filename")
		    || die "Can not open pipe for RMAN at $ENV{ORACLE_HOME}";
	print RMAN_WRITER $rman_script;
	print RMAN_WRITER "exit;\n";
	close RMAN_WRITER;
	my $rman_res = ($? >> 8);
	if ($rman_res != 0) {
		$rman_res = -1;
	}
	open (RMAN_OUT, "$rman_filename") || die "Unable to open tmp file\n";
        my @output = <RMAN_OUT>;
        print @output;
#	if ($rman_res == 0)
#	{
		while ($_ = <RMAN_OUT>)
		{
		    if (/RMAN-00569/)
		    {
		        $rman_res = -1;
			last;
		    }
		    elsif (/RMAN-/)
		    {
		        $rman_res = 1;
		    }
		}
#	}
#	else
#	{
#		$rman_res = -1;
#	}
	close RMAN_OUT;
        if($rman_res == -1)
        {
		print("Error encountered in RMAN Transfer");
#		close STDOUT;
        }
        else
        {
		if ($rman_res == 0)
		{
			print("\nRMAN completed successfully\n");
		}
		else
		{
			print("\nRMAN completed with warnings\n");	
		}
	        $rmanStepCompleted = "yes";
        }
	return $rman_res;
}

sub runCommand
{
	EMD_PERL_DEBUG("migration_util.runCommand(): *** START ***");
	my ($command_string,$oracleHome,$host,$oracleSID,$logFile) = @_;	
	$ENV{'ORACLE_HOME'} = $oracleHome;
	$ENV{'ORACLE_SID'} = $oracleSID;
	$ENV{'LD_LIBRARY_PATH'} = $oracleHome."/lib";
	open(EXP_OUT, "$command_string|");
	while (<EXP_OUT>){
		print;
	}
	close EXP_OUT;
	#close(STDOUT);
	my $result = ($? >> 8);
	if ($result != 0) {
		$result = -1;
	}
#        if ($result == 0)
#       {
		my $srchStrfat = "^Job *.* stopped due to fatal error";
		my $srchStrnfat = "^Job *.* completed with";
		my $srchStrsuc = "^Job *.* successfully completed";	
		if (open (OUT, "$logFile")) #|| die "Unable to open log file\n";
		{
	                while ($_ = <OUT>)
        	        {
				if (m/$srchStrfat/i)
                    		{
                        		$result = -1;
                        		last;
		                }
				elsif (m/$srchStrnfat/i)
                                {
                                        $result = 1;
					last;
                                }
				elsif (m/$srchStrsuc/i)
                                {
                                        $result = 0;
                                        last;
                                }
        		        #elsif (/ORA-/)
		                #{
                		#        $result = 1;
		                #}
                	}
			close OUT;
		}
		else
		{
			print "Could not open log file.";
		}
#        }
#        else
#        {
#                $result = -1;
#        }
#	if ($result == -1) {
#		close STDOUT;
#	}
	return $result;
}
	
	sub createDirObj
	{
		my($host,$port,$sid,$username,$password,$dirObjName,$dirLoc,$pdbservice) = @_;
		my $pdbconn;
		if (not defined $pdbservice)
		{
			$pdbconn = getDBConnection($host,$port,$sid,$username,$password);
		}
		else
		{
			$pdbconn = getDBConnection($host,$port,$sid,$username,$password,$pdbservice);
		}
		my $dirsql = "create or replace directory $dirObjName as '$dirLoc' ";
		$pdbconn->do($dirsql) or die "Could not create directory $dirsql, $DBI::errstr\n";  ;
		&closeDBConnection($pdbconn);
	}
        
	
	sub openWallet
        {
            my($host,$port,$sid,$username,$password,$walletPwd,$pdbservicename) = @_;
		 my $statusQry = "SELECT status from v\$encryption_wallet";
            my $dbconn = getDBConnection($host,$port,$sid,$username,$password);
            my $openWalletSql = "ADMINISTER KEY MANAGEMENT SET KEYSTORE OPEN IDENTIFIED BY \"$walletPwd\"";
			if ($dbconn->do($openWalletSql)) {
				print "\nSuccessfully opened wallet on cdb\n";	
			}
			else
			{
				print("\nCould not open the wallet on the new CDB.$DBI::errstr\n"); 
			}
			my @sts1 = execSQL($dbconn,$statusQry);

			my $pdbnameqry="select pdb from v\$services where name='$pdbservicename'";
			my @pdbnm = execSQL($dbconn,$pdbnameqry);
			my $pname = $pdbnm[0];
			my $sessionchangeqry="alter session set container=$pname";
			if ($dbconn->do($sessionchangeqry)) {
				print "\nSuccessfully set new session to pdb \n";	
			} else {
				print("\nCould not change session using $sessionchangeqry \n  $DBI::errstr\n");
			}

			my @sts2 = execSQL($dbconn,$statusQry);
			
			if ($dbconn->do($openWalletSql)) {
				print "\nSuccessfully opened wallet on pdb\n";	
			}
			else
			{
				print("\nCould not open the wallet on the new PDB.$DBI::errstr\n"); 
			}
			my @sts3 = execSQL($dbconn,$statusQry);
            
			my $useEncKeySql = "ADMINISTER KEY MANAGEMENT SET ENCRYPTION KEY USING TAG 'masterkey' IDENTIFIED BY \"$walletPwd\" WITH BACKUP USING 'MASTERKEY'";
			if ($dbconn->do($useEncKeySql)) {
				print "\nSuccessfully set encrption key \n";	
			} else {
				print("\nCould not set the master key for encryption on the new PDB \n  $DBI::errstr\n");
			}
			my @sts4 = execSQL($dbconn,$statusQry);
			
            &closeDBConnection($dbconn);
        }

	sub printCommand
	{
		my ($ncmd,$usr,$password) = @_;
		my $passwdtxt = "******";
		my $srchTxt = $usr.'/'.$password;
		my $repTxt = $usr.'/'.$passwdtxt;
		$ncmd  =~ s!$srchTxt!$repTxt!g;
		print("\nCommand being executed : $ncmd\n");
	}

	sub cleanup
	{
		my($dir, @filelist) = @_;
		print("\nDeleting temporary files from $dir..\n");
		chdir($dir);
		foreach(@filelist)
		{
			my $fn = $_;
			print("Deleting $fn..\n");
			if (unlink($fn) == 1) {
				print "$fn deleted successfully.\n";
			} else {
				print "Could not delete $fn. \n";
			}
		}
	}

	#check if export and import dbs have some common tablespaces and schemas, if so generate remap command
	sub getRemapList
	{
		my($host,$port,$sid,$pdbservice,$username,$password,$srchost,$srcport,$srcsid,$srcusername,$srcpassword) = @_;
		my $remapTblStr = "";
		my $commonTblSpcCount = 0;
		my @srcTablespaceList =  getObjectList($srchost,$srcport,$srcsid,$srcusername,$srcpassword,"TABLESPACES","SOURCE");
		my @destTablespaceList= getObjectList($host,$port,$sid,$username,$password,"TABLESPACES","DESTINATION",$pdbservice);
		foreach  (@srcTablespaceList) {
			my $srcTblspc = $_;
			foreach  (@destTablespaceList) {
				my $destTblspc = $_;
				if($srcTblspc eq $destTblspc)
				{
					if($remapTblStr ne "")
					{
						$remapTblStr .= ",";
					}
					$remapTblStr.= "'".$srcTblspc."':'".$srcTblspc."_SRC'";
					if($OSNAME eq "WIN"){
						$remapTblStr =~ s/'//g;
       					}
					$commonTblSpcCount++;
				}
			}
		}
		if($commonTblSpcCount > 0)
		{
			$remapTblStr = " REMAP_TABLESPACE=".$remapTblStr;
		}
		return $remapTblStr ;
	}

	sub getObjectList
	{
		my($host,$port,$sid,$username,$password,$objectType,$dbtype,$pdbservice) = @_;
		my $dbconn;
		my $objsql ;
		if($dbtype eq "SOURCE")
		{
			$dbconn = getDBConnection($host,$port,$sid,$username,$password);
		}
		else
		{
			$dbconn = getDBConnection($host,$port,$sid,$username,$password,$pdbservice);
		}
		if($objectType eq "TABLESPACES")
		{
			$objsql = "SELECT TABLESPACE_NAME FROM DBA_TABLESPACES WHERE CONTENTS = 'PERMANENT' AND TABLESPACE_NAME NOT IN ('SYSTEM','SYSAUX')";
		}
		else
		{
			$objsql = "SELECT USERNAME FROM ALL_USERS WHERE USERNAME NOT IN('SYS','SYSTEM')";
		}
		my @objectlist = execSQL($dbconn,$objsql);
		&closeDBConnection($dbconn);
		return @objectlist;
	}

	sub zipfiles
	{
		my($filetxfrDir,$zipfilename, @filelist) = @_;
		my $tar = Archive::Tar->new();

		chdir($filetxfrDir);
		# Add data and dump files:
		print ("Creating tar archive $zipfilename in directory $filetxfrDir.\n");
		foreach(@filelist)
		{
			my $fn = $_;
			print ("Adding file $fn...\n");
			$tar->add_files( $fn);
		}
		# Finished: write compressed zip file
		$tar->write($zipfilename,9);
		print ("tar archive $zipfilename successfully created in directory $filetxfrDir.\n");
                close(STDOUT);
	}


#TODO: Remove when subfolders in ASM are available to be used as DF Loc
sub addCdbPdbToDatafileName
{
	 my($fileList,$prefix) = @_;
	 my $convFileList = "";
	 if(defined  $fileList) {
                        my @datafilesp = split(',',$fileList);
                        my $i=0;
                        foreach(@datafilesp)
                        {
				my $fullFileName = $_;
		                my $filename = basename($fullFileName);
		                my $filedir = dirname($fullFileName);
				my $newFileName = $filename;
				if (index($filedir,"+") == 0 && defined $prefix)
				{
					my @fln = split('\.',$newFileName);
					my $nooc = scalar(@fln);
					if($nooc > 2)
					{
						$newFileName .= "_1";
					}
					$newFileName = $prefix.$newFileName;
				}
				$convFileList .= $filedir.'/'.$newFileName;
				if ($i < (scalar(@datafilesp) - 1)) {
					 $convFileList .= ',';
				}
				$i++;
                        }
          }
	  return $convFileList;
}

sub updateTblspcReadMode
{
        my($host,$port,$sid,$username,$password,$dbName,$source,$readMode,$fileName) = @_;
	my @tblspcList; 
	my $tblspcStr = "";
	if ($source eq 'QUERY')
	{
		my $dbconn = getDBConnection($host,$port,$sid,$username,$password);
		my $query = "SELECT TABLESPACE_NAME FROM DBA_TABLESPACES WHERE CONTENTS = 'PERMANENT' AND TABLESPACE_NAME NOT IN ('SYSTEM','SYSAUX') AND STATUS like 'ONLINE'";
		@tblspcList = execSQL($dbconn,$query);
		&closeDBConnection($dbconn);
		$tblspcStr = join(',', @tblspcList);
		open(WRITER, ">", $fileName)
                    || die "Cannot create file to write tablespace list.";
	        print WRITER $tblspcStr;
        	close WRITER;
	}
	else
	{
		open(READER, $fileName)
        	            || die "Cannot open file to read tablespace list.";	
		foreach (<READER>)
		{
			$tblspcStr = $_;
		}
		@tblspcList = split(',',  $tblspcStr);
	}

        if (scalar(@tblspcList) > 0)
	{
		my $dbconn = getDBConnection($host,$port,$sid,$username,$password);
		foreach(@tblspcList)
                {
			my $query = "ALTER TABLESPACE $_ $readMode";
			execSQL($dbconn,$query);
		}
		&closeDBConnection($dbconn);
		print "Successfully set the mode of tablespaces $tblspcStr to $readMode on $dbName.";
	}
}

sub checkPermissions
{
        my($host,$port,$sid,$username,$password,$dirloc,$tempdirobj) = @_;
	if (not defined $tempdirobj)
	{
	        $tempdirobj = "TEST_TEMP_DIR";
	}
	my $tempfilename = $tempdirobj.".txt";
        createDirObj($host,$port,$sid,$username,$password,$tempdirobj,$dirloc);
        my $permcheckqry = "DECLARE\n";
        $permcheckqry.="        file_handle UTL_FILE.FILE_TYPE; -- file handle of OS flat file\n";
        $permcheckqry.="           retrieved_buffer VARCHAR2(100); -- Line retrieved from flat file\n";
        $permcheckqry.="         BEGIN\n";
        $permcheckqry.="           -- Open file to write into  and get it's file_handle\n";
        $permcheckqry.="           file_handle :=\n";
        $permcheckqry.="             UTL_FILE.FOPEN('$tempdirobj','$tempfilename','W');\n";
        $permcheckqry.="           -- Write a line of text out to the file.\n";
        $permcheckqry.="           UTL_FILE.PUT_LINE(file_handle, 'this is test line');\n";
        $permcheckqry.="           -- Close the file.\n";
        $permcheckqry.="           UTL_FILE.FCLOSE(file_handle);\n";
        $permcheckqry.="           -- Open the same file to read from\n";
        $permcheckqry.="           file_handle :=\n";
        $permcheckqry.="              UTL_FILE.FOPEN('$tempdirobj','$tempfilename','R');\n";
        $permcheckqry.="           -- Read a line from the file.\n";
        $permcheckqry.="           UTL_FILE.GET_LINE (file_handle, retrieved_buffer);\n";
        $permcheckqry.="           -- Print fetched line out to the SQL*PLUS prompt.\n";
        $permcheckqry.="           DBMS_OUTPUT.PUT_LINE(retrieved_buffer);\n";
        $permcheckqry.="           -- CLose the file.\n";
        $permcheckqry.="           UTL_FILE.FCLOSE(file_handle);\n";
        $permcheckqry.="           UTL_FILE.FREMOVE('$tempdirobj', '$tempfilename');\n";
        $permcheckqry.="        EXCEPTION\n";
        $permcheckqry.="           WHEN UTL_FILE.INVALID_PATH THEN\n";
        $permcheckqry.="              DBMS_OUTPUT.PUT_LINE('UTL_FILE.INVALID_PATH');\n";
        $permcheckqry.="              UTL_FILE.FCLOSE(file_handle);\n";
        $permcheckqry.="             raise_application_error(-20000, 'ERROR: Invalid path for file.');\n";
        $permcheckqry.="           WHEN UTL_FILE.READ_ERROR THEN\n";
        $permcheckqry.="              DBMS_OUTPUT.PUT_LINE(' UTL_FILE.READ_ERROR');\n";
        $permcheckqry.="              UTL_FILE.FCLOSE(file_handle);\n";
        $permcheckqry.="              raise_application_error(-20001, 'ERROR: UTL_FILE.READ_ERROR.');\n";
        $permcheckqry.="           WHEN UTL_FILE.WRITE_ERROR THEN\n";
        $permcheckqry.="              DBMS_OUTPUT.PUT_LINE('UTL_FILE.WRITE_ERROR');\n";
        $permcheckqry.="              UTL_FILE.FCLOSE(file_handle);\n";
        $permcheckqry.="              raise_application_error(-20002, 'ERROR: UTL_FILE.WRITE_ERROR.');\n";
        $permcheckqry.="           WHEN UTL_FILE.INVALID_OPERATION THEN\n";
        $permcheckqry.="              DBMS_OUTPUT.PUT_LINE('ERROR : Invalid file operation');\n";
        $permcheckqry.="              UTL_FILE.FCLOSE(file_handle);\n";
        $permcheckqry.="             raise_application_error(-20000, 'ERROR: Invalid file operation');\n";
        $permcheckqry.="         END;\n";
        my $dbconn = getDBConnection($host,$port,$sid,$username,$password);
        my $plstmt = $dbconn->prepare( $permcheckqry );
	my $exitVal = 0;
	if ($plstmt->execute())
	{
		$exitVal = 0;
	}
	else
	{
		$exitVal = -1;
	}
	$plstmt->finish();
        $dbconn->do("drop directory $tempdirobj");
        &closeDBConnection($dbconn);
        exit($exitVal);
}
