#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/migration/sqlUtil.pl /st_emgc_pt-12.1.0.4pg/3 2012/12/26 21:29:39 rtewari Exp $
#
# sqlUtil.pl
# 
# Copyright (c) 2011, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      sqlUtil.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    sresrini    07/24/12 - bug 14361973
#    sresrini    11/10/11 - sql related utilities
#    sresrini    11/10/11 - Creation
# 
use strict;
use warnings;
use DBI;
require "emd_common.pl";
require "semd_common.pl";
require "db/db_common.pl";

$ENV{'LD_LIBRARY_PATH'} = $ENV{'ORACLE_HOME'}."/lib";


sub getDBConnection
{
	my($host,$port,$sid,$username,$password,$servicename) = @_;
	my $address = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=$host)(PORT=$port))(CONNECT_DATA=(SID=$sid)))";
	if(defined $servicename)
	{
		$address = "(DESCRIPTION=(ADDRESS=(PROTOCOL=TCP)(HOST=$host)(PORT=$port))(CONNECT_DATA=(SERVICE_NAME=$servicename)(INSTANCE_NAME=$sid)))";
	}
	
	my $role = "NORMAL";

	my $mode = 0;
	if(uc($username) eq "SYS")
	{
		$role = "SYSDBA";
	}
	#print "\n using connect string $username/$password\@$address as $role\n";
	if($role =~ /SYSDBA/i)
	{
		$mode = 2;
	}
	# --------------------------------------------------------------------
	# +++ Establish Target DB Connection
	# --------------------------------------------------------------------
	my %connection;
	$connection{"db_conninfo"} = $address;
	$connection{"db_username"} = $username;
	$connection{"db_password"} = $password;
	$connection{"db_mode"} = $mode;

	# --------------------------------------------------------------------
	# +++ Establish Target DB Connection
	# --------------------------------------------------------------------
	my $dbconn;
	( $dbconn = DBI->connect('dbi:Oracle:', "$username@".$address, "$password",
		{ora_session_mode => $mode, PrintError => 0, RaiseError => 0, AutoCommit => 0})
	)
    or die "em_error=Could not connect as $username/$address: $DBI::errstr\n";
	return $dbconn;
}

sub execSQL
{
	my $dbconn = $_[0];
	my $sql = $_[1];
	my $stmt;
	if (defined $dbconn)
	{
		$stmt = $dbconn->prepare( $sql );
	}
	else
	{
			 die "em_error=Could not prepare stmt $DBI::errstr\n";
	}
	if(defined $stmt)
	{	
		$stmt->execute();
	}
	else
	{	
		 die "em_error=Could not execute $sql, $DBI::errstr\n"; 
	}
	
	my @result;
	my @row;
	while (@row = $stmt->fetchrow_array()) {
		push(@result,@row);
	}
	$stmt->finish();

	return @result;

}

sub closeDBConnection
{
	my $dbconn = $_[0];
	$dbconn->disconnect();
}
