#!/usr/local/bin/perl
# 
# $Header: emdb/sysman/admin/scripts/db/net/winLsnrUtils.pl /st_emgc_pt-12.1.0.4pg/1 2012/10/26 02:50:02 tpalgudi Exp $
#
# winLsnrUtils.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      winLsnrUtils.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    tpalgudi    10/16/12 - Creation
# 

use strict;
if(!($^O eq "MSWin32")){
    exit(0);
}

use Win32API::File qw( :ALL );

sub fileType{ #first argument is the file whose type you want to know.
#returns "file" if it is not a directory, and "directory" if it is a directory
#returns "error" if it does not exist, or there is some other error
#Would work in UNIX like systems as well
    my $fileName = shift;
    if(opendir(FH, $fileName)){
        close FH;
        return "directory";
    }
    else{
        if(open(FH, $fileName)){
            close FH;
            return "file";
        }
        else{
            return "error";
        }
    }
}

sub win32_file_owner{#first argument is the file whose owner you want to know
    my $fileName = shift;
    my $owner = "";
    my $i = 0;
    if(fileType($fileName) eq "error"){#some error occurred, or the file does not exist
        return -1;
    }
    # / is not an allowed character in an NTFS filename
    # substitute all / with \ to get the correct filename
    $fileName =~ s/\//\\/g;

    if(fileType($fileName) eq "file"){#it is not a directory
        my $systemCommand = "cmd /c \"dir /q $fileName \" |";
        if (!open(CHECKER, "$systemCommand"))
        {
            return -1;
        }
        my @lines = <CHECKER>;
        my $usefulLine = $lines[5];
        my @tokens = split(/\s+/, $usefulLine);
        if(@tokens == 5){#for now, it will be assumed that only the owner and filename can get stuck together.
                         #as and when new cases are discovered, they will be rectified
            my $onlyName = winFileName($fileName);
            my $givenName = $tokens[4];
            $owner;
            if($givenName =~ /^(.*)$onlyName$/i){
                $owner = $1;
            }
            else{
            }

        }
        elsif(@tokens == 6){
            $owner = $tokens[4];
        }
        else{
        }
    }
    elsif(fileType($fileName) eq "directory"){#it is a directory
        my $onlyName = winFileName($fileName);
        my $systemCommand = qq(cmd /c "dir /q /ad $fileName " |);
        if (!open(CHECKER, "$systemCommand"))
        {
            return -1;
        }
        $systemCommand =~ s/\|/\!/g;
        my @lines = <CHECKER>; #contains the lines generated by dir
        shift (@lines);#assuming that 5 lines are header, and two are tail
        shift (@lines);
        shift (@lines);
        shift (@lines);
        shift (@lines);
        pop(@lines);
        pop(@lines);
        #assuming that . will be the first entry in the directory listing
        $_ = shift(@lines);
        if(m/(.*)(\s+)(\S+)(\s*)\.$/){
            s/(.*)(\s+)(\S+)(\s*)\.$/$3/;
            $owner = $_;
        }
        else{#the dir command gave some UNIMAginable output. Giving up.
            return -1;
        }
    }
    chomp $owner;
    return $owner;
}

sub winFileName{#first arguments is the file path
#returns the last part of the filename(after removal of the containing directory)
        $_ = shift;
        s/^(.*)\\(.*)$/$2/;
        return $_;
}

1;
